/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.OpenInterval;

@Schema(description="Dates when the business is closed or open with a different time window.")
public class ExceptionDates {
    @SerializedName(value="ExceptionDate")
    private String exceptionDate = null;
    @SerializedName(value="IsOpen")
    private Boolean isOpen = null;
    @SerializedName(value="OpenIntervals")
    private List<OpenInterval> openIntervals = null;

    public ExceptionDates exceptionDate(String exceptionDate) {
        this.exceptionDate = exceptionDate;
        return this;
    }

    @Schema(description="Date when the business is closed, in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> date format.")
    public String getExceptionDate() {
        return this.exceptionDate;
    }

    public void setExceptionDate(String exceptionDate) {
        this.exceptionDate = exceptionDate;
    }

    public ExceptionDates isOpen(Boolean isOpen) {
        this.isOpen = isOpen;
        return this;
    }

    @Schema(description="Boolean indicating if the business is closed or open on that date.")
    public Boolean isIsOpen() {
        return this.isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public ExceptionDates openIntervals(List<OpenInterval> openIntervals) {
        this.openIntervals = openIntervals;
        return this;
    }

    public ExceptionDates addOpenIntervalsItem(OpenInterval openIntervalsItem) {
        if (this.openIntervals == null) {
            this.openIntervals = new ArrayList<OpenInterval>();
        }
        this.openIntervals.add(openIntervalsItem);
        return this;
    }

    @Schema(description="Time window during the day when the business is open.")
    public List<OpenInterval> getOpenIntervals() {
        return this.openIntervals;
    }

    public void setOpenIntervals(List<OpenInterval> openIntervals) {
        this.openIntervals = openIntervals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionDates exceptionDates = (ExceptionDates)o;
        return Objects.equals(this.exceptionDate, exceptionDates.exceptionDate) && Objects.equals(this.isOpen, exceptionDates.isOpen) && Objects.equals(this.openIntervals, exceptionDates.openIntervals);
    }

    public int hashCode() {
        return Objects.hash(this.exceptionDate, this.isOpen, this.openIntervals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExceptionDates {\n");
        sb.append("    exceptionDate: ").append(this.toIndentedString(this.exceptionDate)).append("\n");
        sb.append("    isOpen: ").append(this.toIndentedString(this.isOpen)).append("\n");
        sb.append("    openIntervals: ").append(this.toIndentedString(this.openIntervals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

