/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.PackageDetail;

@Schema(description="The request schema for an shipment confirmation.")
public class ConfirmShipmentRequest {
    @SerializedName(value="packageDetail")
    private PackageDetail packageDetail = null;
    @SerializedName(value="codCollectionMethod")
    private CodCollectionMethodEnum codCollectionMethod = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;

    public ConfirmShipmentRequest packageDetail(PackageDetail packageDetail) {
        this.packageDetail = packageDetail;
        return this;
    }

    @Schema(required=true, description="")
    public PackageDetail getPackageDetail() {
        return this.packageDetail;
    }

    public void setPackageDetail(PackageDetail packageDetail) {
        this.packageDetail = packageDetail;
    }

    public ConfirmShipmentRequest codCollectionMethod(CodCollectionMethodEnum codCollectionMethod) {
        this.codCollectionMethod = codCollectionMethod;
        return this;
    }

    @Schema(description="The COD collection method (only supported in the JP marketplace).")
    public CodCollectionMethodEnum getCodCollectionMethod() {
        return this.codCollectionMethod;
    }

    public void setCodCollectionMethod(CodCollectionMethodEnum codCollectionMethod) {
        this.codCollectionMethod = codCollectionMethod;
    }

    public ConfirmShipmentRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfirmShipmentRequest confirmShipmentRequest = (ConfirmShipmentRequest)o;
        return Objects.equals(this.packageDetail, confirmShipmentRequest.packageDetail) && Objects.equals((Object)this.codCollectionMethod, (Object)confirmShipmentRequest.codCollectionMethod) && Objects.equals(this.marketplaceId, confirmShipmentRequest.marketplaceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.packageDetail, this.codCollectionMethod, this.marketplaceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfirmShipmentRequest {\n");
        sb.append("    packageDetail: ").append(this.toIndentedString(this.packageDetail)).append("\n");
        sb.append("    codCollectionMethod: ").append(this.toIndentedString((Object)this.codCollectionMethod)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CodCollectionMethodEnum {
        DIRECTPAYMENT("DirectPayment");

        private String value;

        private CodCollectionMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CodCollectionMethodEnum fromValue(String input) {
            for (CodCollectionMethodEnum b : CodCollectionMethodEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CodCollectionMethodEnum> {
            public void write(JsonWriter jsonWriter, CodCollectionMethodEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public CodCollectionMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CodCollectionMethodEnum.fromValue(value);
            }
        }
    }
}

