/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Contains information regarding the Shipping Settings Automation program, such as whether the order's shipping settings were generated automatically, and what those settings are.")
public class AutomatedShippingSettings {
    @SerializedName(value="HasAutomatedShippingSettings")
    private Boolean hasAutomatedShippingSettings = null;
    @SerializedName(value="AutomatedCarrier")
    private String automatedCarrier = null;
    @SerializedName(value="AutomatedShipMethod")
    private String automatedShipMethod = null;

    public AutomatedShippingSettings hasAutomatedShippingSettings(Boolean hasAutomatedShippingSettings) {
        this.hasAutomatedShippingSettings = hasAutomatedShippingSettings;
        return this;
    }

    @Schema(description="When true, this order has automated shipping settings generated by Amazon. This order could be identified as an SSA order.")
    public Boolean isHasAutomatedShippingSettings() {
        return this.hasAutomatedShippingSettings;
    }

    public void setHasAutomatedShippingSettings(Boolean hasAutomatedShippingSettings) {
        this.hasAutomatedShippingSettings = hasAutomatedShippingSettings;
    }

    public AutomatedShippingSettings automatedCarrier(String automatedCarrier) {
        this.automatedCarrier = automatedCarrier;
        return this;
    }

    @Schema(description="Auto-generated carrier for SSA orders.")
    public String getAutomatedCarrier() {
        return this.automatedCarrier;
    }

    public void setAutomatedCarrier(String automatedCarrier) {
        this.automatedCarrier = automatedCarrier;
    }

    public AutomatedShippingSettings automatedShipMethod(String automatedShipMethod) {
        this.automatedShipMethod = automatedShipMethod;
        return this;
    }

    @Schema(description="Auto-generated ship method for SSA orders.")
    public String getAutomatedShipMethod() {
        return this.automatedShipMethod;
    }

    public void setAutomatedShipMethod(String automatedShipMethod) {
        this.automatedShipMethod = automatedShipMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutomatedShippingSettings automatedShippingSettings = (AutomatedShippingSettings)o;
        return Objects.equals(this.hasAutomatedShippingSettings, automatedShippingSettings.hasAutomatedShippingSettings) && Objects.equals(this.automatedCarrier, automatedShippingSettings.automatedCarrier) && Objects.equals(this.automatedShipMethod, automatedShippingSettings.automatedShipMethod);
    }

    public int hashCode() {
        return Objects.hash(this.hasAutomatedShippingSettings, this.automatedCarrier, this.automatedShipMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutomatedShippingSettings {\n");
        sb.append("    hasAutomatedShippingSettings: ").append(this.toIndentedString(this.hasAutomatedShippingSettings)).append("\n");
        sb.append("    automatedCarrier: ").append(this.toIndentedString(this.automatedCarrier)).append("\n");
        sb.append("    automatedShipMethod: ").append(this.toIndentedString(this.automatedShipMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

