/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Contains the list of programs that Amazon associates with an item.  Possible programs are:  - **Subscribe and Save**: Offers recurring, scheduled deliveries to Amazon customers and Amazon Business customers for their frequently ordered products. - **FBM Ship+**: Unlocks expedited shipping without the extra cost. Helps you to provide accurate and fast delivery dates to Amazon customers. You also receive protection from late deliveries, a discount on expedited shipping rates, and cash back when you ship.")
public class AmazonPrograms {
    @SerializedName(value="Programs")
    private List<String> programs = new ArrayList<String>();

    public AmazonPrograms programs(List<String> programs) {
        this.programs = programs;
        return this;
    }

    public AmazonPrograms addProgramsItem(String programsItem) {
        this.programs.add(programsItem);
        return this;
    }

    @Schema(required=true, description="A list of the programs that Amazon associates with the order item.  **Possible values**: `SUBSCRIBE_AND_SAVE`, `FBM_SHIP_PLUS`")
    public List<String> getPrograms() {
        return this.programs;
    }

    public void setPrograms(List<String> programs) {
        this.programs = programs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonPrograms amazonPrograms = (AmazonPrograms)o;
        return Objects.equals(this.programs, amazonPrograms.programs);
    }

    public int hashCode() {
        return Objects.hash(this.programs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmazonPrograms {\n");
        sb.append("    programs: ").append(this.toIndentedString(this.programs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

