/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.notifications.v1;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.notifications.v1.AggregationFilter;
import software.amazon.spapi.models.notifications.v1.MarketplaceIds;
import software.amazon.spapi.models.notifications.v1.OrderChangeTypes;

@Schema(description="A `notificationType` specific filter. This object contains all of the currently available filters and properties that you can use to define a `notificationType` specific filter.")
public class EventFilter
extends AggregationFilter {
    @SerializedName(value="marketplaceIds")
    private MarketplaceIds marketplaceIds = null;
    @SerializedName(value="orderChangeTypes")
    private OrderChangeTypes orderChangeTypes = null;
    @SerializedName(value="eventFilterType")
    private EventFilterTypeEnum eventFilterType = null;

    public EventFilter marketplaceIds(MarketplaceIds marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    @Schema(description="")
    public MarketplaceIds getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(MarketplaceIds marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public EventFilter orderChangeTypes(OrderChangeTypes orderChangeTypes) {
        this.orderChangeTypes = orderChangeTypes;
        return this;
    }

    @Schema(description="")
    public OrderChangeTypes getOrderChangeTypes() {
        return this.orderChangeTypes;
    }

    public void setOrderChangeTypes(OrderChangeTypes orderChangeTypes) {
        this.orderChangeTypes = orderChangeTypes;
    }

    public EventFilter eventFilterType(EventFilterTypeEnum eventFilterType) {
        this.eventFilterType = eventFilterType;
        return this;
    }

    @Schema(required=true, description="An `eventFilterType` value that is supported by the specific `notificationType`. This is used by the subscription service to determine the type of event filter. Refer to [Notification Type Values](https://developer-docs.amazon.com/sp-api/docs/notification-type-values) to determine if an `eventFilterType` is supported.")
    public EventFilterTypeEnum getEventFilterType() {
        return this.eventFilterType;
    }

    public void setEventFilterType(EventFilterTypeEnum eventFilterType) {
        this.eventFilterType = eventFilterType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventFilter eventFilter = (EventFilter)o;
        return Objects.equals(this.marketplaceIds, eventFilter.marketplaceIds) && Objects.equals(this.orderChangeTypes, eventFilter.orderChangeTypes) && Objects.equals((Object)this.eventFilterType, (Object)eventFilter.eventFilterType) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceIds, this.orderChangeTypes, this.eventFilterType, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventFilter {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    orderChangeTypes: ").append(this.toIndentedString(this.orderChangeTypes)).append("\n");
        sb.append("    eventFilterType: ").append(this.toIndentedString((Object)this.eventFilterType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventFilterTypeEnum {
        ANY_OFFER_CHANGED("ANY_OFFER_CHANGED"),
        ORDER_CHANGE("ORDER_CHANGE");

        private String value;

        private EventFilterTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventFilterTypeEnum fromValue(String input) {
            for (EventFilterTypeEnum b : EventFilterTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EventFilterTypeEnum> {
            public void write(JsonWriter jsonWriter, EventFilterTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public EventFilterTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventFilterTypeEnum.fromValue(value);
            }
        }
    }
}

