/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.notifications.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The Amazon EventBridge destination.")
public class EventBridgeResource {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="region")
    private String region = null;
    @SerializedName(value="accountId")
    private String accountId = null;

    public EventBridgeResource name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The name of the partner event source associated with the destination.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EventBridgeResource region(String region) {
        this.region = region;
        return this;
    }

    @Schema(required=true, description="The AWS region in which you receive the notifications. For AWS regions that are supported in Amazon EventBridge, refer to [Amazon EventBridge endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/ev.html).")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public EventBridgeResource accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(required=true, description="The identifier for the AWS account that is responsible for charges related to receiving notifications.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventBridgeResource eventBridgeResource = (EventBridgeResource)o;
        return Objects.equals(this.name, eventBridgeResource.name) && Objects.equals(this.region, eventBridgeResource.region) && Objects.equals(this.accountId, eventBridgeResource.accountId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.region, this.accountId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventBridgeResource {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

