/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.merchantfulfillment.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.merchantfulfillment.v0.AdditionalSellerInputsList;
import software.amazon.spapi.models.merchantfulfillment.v0.DangerousGoodsDetails;
import software.amazon.spapi.models.merchantfulfillment.v0.LiquidVolume;
import software.amazon.spapi.models.merchantfulfillment.v0.TransparencyCodeList;
import software.amazon.spapi.models.merchantfulfillment.v0.Weight;

@Schema(description="An Amazon order item identifier and a quantity.")
public class Item {
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="Quantity")
    private Integer quantity = null;
    @SerializedName(value="ItemWeight")
    private Weight itemWeight = null;
    @SerializedName(value="ItemDescription")
    private String itemDescription = null;
    @SerializedName(value="TransparencyCodeList")
    private TransparencyCodeList transparencyCodeList = null;
    @SerializedName(value="ItemLevelSellerInputsList")
    private AdditionalSellerInputsList itemLevelSellerInputsList = null;
    @SerializedName(value="LiquidVolume")
    private LiquidVolume liquidVolume = null;
    @SerializedName(value="IsHazmat")
    private Boolean isHazmat = null;
    @SerializedName(value="DangerousGoodsDetails")
    private DangerousGoodsDetails dangerousGoodsDetails = null;

    public Item orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @Schema(required=true, description="")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public Item quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(required=true, description="")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Item itemWeight(Weight itemWeight) {
        this.itemWeight = itemWeight;
        return this;
    }

    @Schema(description="")
    public Weight getItemWeight() {
        return this.itemWeight;
    }

    public void setItemWeight(Weight itemWeight) {
        this.itemWeight = itemWeight;
    }

    public Item itemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
        return this;
    }

    @Schema(description="")
    public String getItemDescription() {
        return this.itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    public Item transparencyCodeList(TransparencyCodeList transparencyCodeList) {
        this.transparencyCodeList = transparencyCodeList;
        return this;
    }

    @Schema(description="")
    public TransparencyCodeList getTransparencyCodeList() {
        return this.transparencyCodeList;
    }

    public void setTransparencyCodeList(TransparencyCodeList transparencyCodeList) {
        this.transparencyCodeList = transparencyCodeList;
    }

    public Item itemLevelSellerInputsList(AdditionalSellerInputsList itemLevelSellerInputsList) {
        this.itemLevelSellerInputsList = itemLevelSellerInputsList;
        return this;
    }

    @Schema(description="")
    public AdditionalSellerInputsList getItemLevelSellerInputsList() {
        return this.itemLevelSellerInputsList;
    }

    public void setItemLevelSellerInputsList(AdditionalSellerInputsList itemLevelSellerInputsList) {
        this.itemLevelSellerInputsList = itemLevelSellerInputsList;
    }

    public Item liquidVolume(LiquidVolume liquidVolume) {
        this.liquidVolume = liquidVolume;
        return this;
    }

    @Schema(description="")
    public LiquidVolume getLiquidVolume() {
        return this.liquidVolume;
    }

    public void setLiquidVolume(LiquidVolume liquidVolume) {
        this.liquidVolume = liquidVolume;
    }

    public Item isHazmat(Boolean isHazmat) {
        this.isHazmat = isHazmat;
        return this;
    }

    @Schema(description="When true, the item qualifies as hazardous materials (hazmat). Defaults to false.")
    public Boolean isIsHazmat() {
        return this.isHazmat;
    }

    public void setIsHazmat(Boolean isHazmat) {
        this.isHazmat = isHazmat;
    }

    public Item dangerousGoodsDetails(DangerousGoodsDetails dangerousGoodsDetails) {
        this.dangerousGoodsDetails = dangerousGoodsDetails;
        return this;
    }

    @Schema(description="")
    public DangerousGoodsDetails getDangerousGoodsDetails() {
        return this.dangerousGoodsDetails;
    }

    public void setDangerousGoodsDetails(DangerousGoodsDetails dangerousGoodsDetails) {
        this.dangerousGoodsDetails = dangerousGoodsDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.orderItemId, item.orderItemId) && Objects.equals(this.quantity, item.quantity) && Objects.equals(this.itemWeight, item.itemWeight) && Objects.equals(this.itemDescription, item.itemDescription) && Objects.equals(this.transparencyCodeList, item.transparencyCodeList) && Objects.equals(this.itemLevelSellerInputsList, item.itemLevelSellerInputsList) && Objects.equals(this.liquidVolume, item.liquidVolume) && Objects.equals(this.isHazmat, item.isHazmat) && Objects.equals(this.dangerousGoodsDetails, item.dangerousGoodsDetails);
    }

    public int hashCode() {
        return Objects.hash(this.orderItemId, this.quantity, this.itemWeight, this.itemDescription, this.transparencyCodeList, this.itemLevelSellerInputsList, this.liquidVolume, this.isHazmat, this.dangerousGoodsDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    itemWeight: ").append(this.toIndentedString(this.itemWeight)).append("\n");
        sb.append("    itemDescription: ").append(this.toIndentedString(this.itemDescription)).append("\n");
        sb.append("    transparencyCodeList: ").append(this.toIndentedString(this.transparencyCodeList)).append("\n");
        sb.append("    itemLevelSellerInputsList: ").append(this.toIndentedString(this.itemLevelSellerInputsList)).append("\n");
        sb.append("    liquidVolume: ").append(this.toIndentedString(this.liquidVolume)).append("\n");
        sb.append("    isHazmat: ").append(this.toIndentedString(this.isHazmat)).append("\n");
        sb.append("    dangerousGoodsDetails: ").append(this.toIndentedString(this.dangerousGoodsDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

