/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.Item;
import software.amazon.spapi.models.listings.items.v2021_08_01.Pagination;

@Schema(description="Selling partner listings items and search related metadata.")
public class ItemSearchResults {
    @SerializedName(value="numberOfResults")
    private Integer numberOfResults = null;
    @SerializedName(value="pagination")
    private Pagination pagination = null;
    @SerializedName(value="items")
    private List<Item> items = new ArrayList<Item>();

    public ItemSearchResults numberOfResults(Integer numberOfResults) {
        this.numberOfResults = numberOfResults;
        return this;
    }

    @Schema(required=true, description="The total number of selling partner listings items found for the search criteria (only results up to the page count limit is returned per request regardless of the number found).  Note: The maximum number of items (SKUs) that can be returned and paged through is 1000.")
    public Integer getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(Integer numberOfResults) {
        this.numberOfResults = numberOfResults;
    }

    public ItemSearchResults pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    @Schema(description="")
    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public ItemSearchResults items(List<Item> items) {
        this.items = items;
        return this;
    }

    public ItemSearchResults addItemsItem(Item itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @Schema(required=true, description="A list of listings items.")
    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemSearchResults itemSearchResults = (ItemSearchResults)o;
        return Objects.equals(this.numberOfResults, itemSearchResults.numberOfResults) && Objects.equals(this.pagination, itemSearchResults.pagination) && Objects.equals(this.items, itemSearchResults.items);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfResults, this.pagination, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemSearchResults {\n");
        sb.append("    numberOfResults: ").append(this.toIndentedString(this.numberOfResults)).append("\n");
        sb.append("    pagination: ").append(this.toIndentedString(this.pagination)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

