/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemVariationTheme;

@Schema(description="The relationship details for a listing item.")
public class ItemRelationship {
    @SerializedName(value="childSkus")
    private List<String> childSkus = null;
    @SerializedName(value="parentSkus")
    private List<String> parentSkus = null;
    @SerializedName(value="variationTheme")
    private ItemVariationTheme variationTheme = null;
    @SerializedName(value="type")
    private TypeEnum type = null;

    public ItemRelationship childSkus(List<String> childSkus) {
        this.childSkus = childSkus;
        return this;
    }

    public ItemRelationship addChildSkusItem(String childSkusItem) {
        if (this.childSkus == null) {
            this.childSkus = new ArrayList<String>();
        }
        this.childSkus.add(childSkusItem);
        return this;
    }

    @Schema(description="Identifiers (SKUs) of the related items that are children of this listing item.")
    public List<String> getChildSkus() {
        return this.childSkus;
    }

    public void setChildSkus(List<String> childSkus) {
        this.childSkus = childSkus;
    }

    public ItemRelationship parentSkus(List<String> parentSkus) {
        this.parentSkus = parentSkus;
        return this;
    }

    public ItemRelationship addParentSkusItem(String parentSkusItem) {
        if (this.parentSkus == null) {
            this.parentSkus = new ArrayList<String>();
        }
        this.parentSkus.add(parentSkusItem);
        return this;
    }

    @Schema(description="Identifiers (SKUs) of the related items that are parents of this listing item.")
    public List<String> getParentSkus() {
        return this.parentSkus;
    }

    public void setParentSkus(List<String> parentSkus) {
        this.parentSkus = parentSkus;
    }

    public ItemRelationship variationTheme(ItemVariationTheme variationTheme) {
        this.variationTheme = variationTheme;
        return this;
    }

    @Schema(description="")
    public ItemVariationTheme getVariationTheme() {
        return this.variationTheme;
    }

    public void setVariationTheme(ItemVariationTheme variationTheme) {
        this.variationTheme = variationTheme;
    }

    public ItemRelationship type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(example="VARIATION", required=true, description="The type of relationship.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemRelationship itemRelationship = (ItemRelationship)o;
        return Objects.equals(this.childSkus, itemRelationship.childSkus) && Objects.equals(this.parentSkus, itemRelationship.parentSkus) && Objects.equals(this.variationTheme, itemRelationship.variationTheme) && Objects.equals((Object)this.type, (Object)itemRelationship.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.childSkus, this.parentSkus, this.variationTheme, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemRelationship {\n");
        sb.append("    childSkus: ").append(this.toIndentedString(this.childSkus)).append("\n");
        sb.append("    parentSkus: ").append(this.toIndentedString(this.parentSkus)).append("\n");
        sb.append("    variationTheme: ").append(this.toIndentedString(this.variationTheme)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        VARIATION("VARIATION"),
        PACKAGE_HIERARCHY("PACKAGE_HIERARCHY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

