/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.IssueEnforcements;

@Schema(description="An issue with a listings item.")
public class Issue {
    @SerializedName(value="code")
    private String code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="severity")
    private SeverityEnum severity = null;
    @SerializedName(value="attributeNames")
    private List<String> attributeNames = null;
    @SerializedName(value="categories")
    private List<String> categories = new ArrayList<String>();
    @SerializedName(value="enforcements")
    private IssueEnforcements enforcements = null;

    public Issue code(String code) {
        this.code = code;
        return this;
    }

    @Schema(required=true, description="An issue code that identifies the type of issue.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Issue message(String message) {
        this.message = message;
        return this;
    }

    @Schema(required=true, description="A message that describes the issue.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Issue severity(SeverityEnum severity) {
        this.severity = severity;
        return this;
    }

    @Schema(required=true, description="The severity of the issue.")
    public SeverityEnum getSeverity() {
        return this.severity;
    }

    public void setSeverity(SeverityEnum severity) {
        this.severity = severity;
    }

    public Issue attributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames;
        return this;
    }

    public Issue addAttributeNamesItem(String attributeNamesItem) {
        if (this.attributeNames == null) {
            this.attributeNames = new ArrayList<String>();
        }
        this.attributeNames.add(attributeNamesItem);
        return this;
    }

    @Schema(description="The names of the attributes associated with the issue, if applicable.")
    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    public Issue categories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public Issue addCategoriesItem(String categoriesItem) {
        this.categories.add(categoriesItem);
        return this;
    }

    @Schema(example="[\"INVALID_ATTRIBUTE\"]", required=true, description="List of issue categories.   Possible values:   * 'INVALID_ATTRIBUTE' - Indicating an invalid attribute in the listing.   * 'MISSING_ATTRIBUTE' - Highlighting a missing attribute in the listing.   * 'INVALID_IMAGE' - Signifying an invalid image in the listing.   * 'MISSING_IMAGE' - Noting the absence of an image in the listing.   * 'INVALID_PRICE' - Pertaining to issues with the listing's price-related attributes.   * 'MISSING_PRICE' - Pointing out the absence of a price attribute in the listing.   * 'DUPLICATE' - Identifying listings with potential duplicate problems, such as this ASIN potentially being a duplicate of another ASIN.   * 'QUALIFICATION_REQUIRED' - Indicating that the listing requires qualification-related approval.")
    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public Issue enforcements(IssueEnforcements enforcements) {
        this.enforcements = enforcements;
        return this;
    }

    @Schema(description="")
    public IssueEnforcements getEnforcements() {
        return this.enforcements;
    }

    public void setEnforcements(IssueEnforcements enforcements) {
        this.enforcements = enforcements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return Objects.equals(this.code, issue.code) && Objects.equals(this.message, issue.message) && Objects.equals((Object)this.severity, (Object)issue.severity) && Objects.equals(this.attributeNames, issue.attributeNames) && Objects.equals(this.categories, issue.categories) && Objects.equals(this.enforcements, issue.enforcements);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message, this.severity, this.attributeNames, this.categories, this.enforcements});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Issue {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    attributeNames: ").append(this.toIndentedString(this.attributeNames)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    enforcements: ").append(this.toIndentedString(this.enforcements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SeverityEnum {
        ERROR("ERROR"),
        WARNING("WARNING"),
        INFO("INFO");

        private String value;

        private SeverityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SeverityEnum fromValue(String input) {
            for (SeverityEnum b : SeverityEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SeverityEnum> {
            public void write(JsonWriter jsonWriter, SeverityEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SeverityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SeverityEnum.fromValue(value);
            }
        }
    }
}

