/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.invoicing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Objects;
import software.amazon.spapi.models.invoicing.v0.Money;
import software.amazon.spapi.models.invoicing.v0.SerialNumbersList;

@Schema(description="The shipment item information required by a seller to issue a shipment invoice.")
public class ShipmentItem {
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="Title")
    private String title = null;
    @SerializedName(value="QuantityOrdered")
    private BigDecimal quantityOrdered = null;
    @SerializedName(value="ItemPrice")
    private Money itemPrice = null;
    @SerializedName(value="ShippingPrice")
    private Money shippingPrice = null;
    @SerializedName(value="GiftWrapPrice")
    private Money giftWrapPrice = null;
    @SerializedName(value="ShippingDiscount")
    private Money shippingDiscount = null;
    @SerializedName(value="PromotionDiscount")
    private Money promotionDiscount = null;
    @SerializedName(value="SerialNumbers")
    private SerialNumbersList serialNumbers = null;

    public ShipmentItem ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @Schema(description="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public ShipmentItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @Schema(description="The seller SKU of the item.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public ShipmentItem orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @Schema(description="The Amazon-defined identifier for the order item.")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public ShipmentItem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The name of the item.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ShipmentItem quantityOrdered(BigDecimal quantityOrdered) {
        this.quantityOrdered = quantityOrdered;
        return this;
    }

    @Schema(description="The number of items ordered.")
    public BigDecimal getQuantityOrdered() {
        return this.quantityOrdered;
    }

    public void setQuantityOrdered(BigDecimal quantityOrdered) {
        this.quantityOrdered = quantityOrdered;
    }

    public ShipmentItem itemPrice(Money itemPrice) {
        this.itemPrice = itemPrice;
        return this;
    }

    @Schema(description="")
    public Money getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(Money itemPrice) {
        this.itemPrice = itemPrice;
    }

    public ShipmentItem shippingPrice(Money shippingPrice) {
        this.shippingPrice = shippingPrice;
        return this;
    }

    @Schema(description="")
    public Money getShippingPrice() {
        return this.shippingPrice;
    }

    public void setShippingPrice(Money shippingPrice) {
        this.shippingPrice = shippingPrice;
    }

    public ShipmentItem giftWrapPrice(Money giftWrapPrice) {
        this.giftWrapPrice = giftWrapPrice;
        return this;
    }

    @Schema(description="")
    public Money getGiftWrapPrice() {
        return this.giftWrapPrice;
    }

    public void setGiftWrapPrice(Money giftWrapPrice) {
        this.giftWrapPrice = giftWrapPrice;
    }

    public ShipmentItem shippingDiscount(Money shippingDiscount) {
        this.shippingDiscount = shippingDiscount;
        return this;
    }

    @Schema(description="")
    public Money getShippingDiscount() {
        return this.shippingDiscount;
    }

    public void setShippingDiscount(Money shippingDiscount) {
        this.shippingDiscount = shippingDiscount;
    }

    public ShipmentItem promotionDiscount(Money promotionDiscount) {
        this.promotionDiscount = promotionDiscount;
        return this;
    }

    @Schema(description="")
    public Money getPromotionDiscount() {
        return this.promotionDiscount;
    }

    public void setPromotionDiscount(Money promotionDiscount) {
        this.promotionDiscount = promotionDiscount;
    }

    public ShipmentItem serialNumbers(SerialNumbersList serialNumbers) {
        this.serialNumbers = serialNumbers;
        return this;
    }

    @Schema(description="")
    public SerialNumbersList getSerialNumbers() {
        return this.serialNumbers;
    }

    public void setSerialNumbers(SerialNumbersList serialNumbers) {
        this.serialNumbers = serialNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentItem shipmentItem = (ShipmentItem)o;
        return Objects.equals(this.ASIN, shipmentItem.ASIN) && Objects.equals(this.sellerSKU, shipmentItem.sellerSKU) && Objects.equals(this.orderItemId, shipmentItem.orderItemId) && Objects.equals(this.title, shipmentItem.title) && Objects.equals(this.quantityOrdered, shipmentItem.quantityOrdered) && Objects.equals(this.itemPrice, shipmentItem.itemPrice) && Objects.equals(this.shippingPrice, shipmentItem.shippingPrice) && Objects.equals(this.giftWrapPrice, shipmentItem.giftWrapPrice) && Objects.equals(this.shippingDiscount, shipmentItem.shippingDiscount) && Objects.equals(this.promotionDiscount, shipmentItem.promotionDiscount) && Objects.equals(this.serialNumbers, shipmentItem.serialNumbers);
    }

    public int hashCode() {
        return Objects.hash(this.ASIN, this.sellerSKU, this.orderItemId, this.title, this.quantityOrdered, this.itemPrice, this.shippingPrice, this.giftWrapPrice, this.shippingDiscount, this.promotionDiscount, this.serialNumbers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentItem {\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    quantityOrdered: ").append(this.toIndentedString(this.quantityOrdered)).append("\n");
        sb.append("    itemPrice: ").append(this.toIndentedString(this.itemPrice)).append("\n");
        sb.append("    shippingPrice: ").append(this.toIndentedString(this.shippingPrice)).append("\n");
        sb.append("    giftWrapPrice: ").append(this.toIndentedString(this.giftWrapPrice)).append("\n");
        sb.append("    shippingDiscount: ").append(this.toIndentedString(this.shippingDiscount)).append("\n");
        sb.append("    promotionDiscount: ").append(this.toIndentedString(this.promotionDiscount)).append("\n");
        sb.append("    serialNumbers: ").append(this.toIndentedString(this.serialNumbers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

