/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FulfillmentReturnItemStatus;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.ReturnItemDisposition;

@Schema(description="An item that Amazon accepted for return.")
public class ReturnItem {
    @SerializedName(value="sellerReturnItemId")
    private String sellerReturnItemId = null;
    @SerializedName(value="sellerFulfillmentOrderItemId")
    private String sellerFulfillmentOrderItemId = null;
    @SerializedName(value="amazonShipmentId")
    private String amazonShipmentId = null;
    @SerializedName(value="sellerReturnReasonCode")
    private String sellerReturnReasonCode = null;
    @SerializedName(value="returnComment")
    private String returnComment = null;
    @SerializedName(value="amazonReturnReasonCode")
    private String amazonReturnReasonCode = null;
    @SerializedName(value="status")
    private FulfillmentReturnItemStatus status = null;
    @SerializedName(value="statusChangedDate")
    private OffsetDateTime statusChangedDate = null;
    @SerializedName(value="returnAuthorizationId")
    private String returnAuthorizationId = null;
    @SerializedName(value="returnReceivedCondition")
    private ReturnItemDisposition returnReceivedCondition = null;
    @SerializedName(value="fulfillmentCenterId")
    private String fulfillmentCenterId = null;

    public ReturnItem sellerReturnItemId(String sellerReturnItemId) {
        this.sellerReturnItemId = sellerReturnItemId;
        return this;
    }

    @Schema(required=true, description="An identifier the seller assigns to the return item.")
    public String getSellerReturnItemId() {
        return this.sellerReturnItemId;
    }

    public void setSellerReturnItemId(String sellerReturnItemId) {
        this.sellerReturnItemId = sellerReturnItemId;
    }

    public ReturnItem sellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
        return this;
    }

    @Schema(required=true, description="The identifier assigned to the item by the seller when the fulfillment order was created.")
    public String getSellerFulfillmentOrderItemId() {
        return this.sellerFulfillmentOrderItemId;
    }

    public void setSellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
    }

    public ReturnItem amazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
        return this;
    }

    @Schema(required=true, description="The identifier for the shipment that is associated with the return item.")
    public String getAmazonShipmentId() {
        return this.amazonShipmentId;
    }

    public void setAmazonShipmentId(String amazonShipmentId) {
        this.amazonShipmentId = amazonShipmentId;
    }

    public ReturnItem sellerReturnReasonCode(String sellerReturnReasonCode) {
        this.sellerReturnReasonCode = sellerReturnReasonCode;
        return this;
    }

    @Schema(required=true, description="The return reason code assigned to the return item by the seller.")
    public String getSellerReturnReasonCode() {
        return this.sellerReturnReasonCode;
    }

    public void setSellerReturnReasonCode(String sellerReturnReasonCode) {
        this.sellerReturnReasonCode = sellerReturnReasonCode;
    }

    public ReturnItem returnComment(String returnComment) {
        this.returnComment = returnComment;
        return this;
    }

    @Schema(description="An optional comment about the return item.")
    public String getReturnComment() {
        return this.returnComment;
    }

    public void setReturnComment(String returnComment) {
        this.returnComment = returnComment;
    }

    public ReturnItem amazonReturnReasonCode(String amazonReturnReasonCode) {
        this.amazonReturnReasonCode = amazonReturnReasonCode;
        return this;
    }

    @Schema(description="The return reason code that the Amazon fulfillment center assigned to the return item.")
    public String getAmazonReturnReasonCode() {
        return this.amazonReturnReasonCode;
    }

    public void setAmazonReturnReasonCode(String amazonReturnReasonCode) {
        this.amazonReturnReasonCode = amazonReturnReasonCode;
    }

    public ReturnItem status(FulfillmentReturnItemStatus status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="")
    public FulfillmentReturnItemStatus getStatus() {
        return this.status;
    }

    public void setStatus(FulfillmentReturnItemStatus status) {
        this.status = status;
    }

    public ReturnItem statusChangedDate(OffsetDateTime statusChangedDate) {
        this.statusChangedDate = statusChangedDate;
        return this;
    }

    @Schema(required=true, description="")
    public OffsetDateTime getStatusChangedDate() {
        return this.statusChangedDate;
    }

    public void setStatusChangedDate(OffsetDateTime statusChangedDate) {
        this.statusChangedDate = statusChangedDate;
    }

    public ReturnItem returnAuthorizationId(String returnAuthorizationId) {
        this.returnAuthorizationId = returnAuthorizationId;
        return this;
    }

    @Schema(description="Identifies the return authorization used to return this item. Refer to `ReturnAuthorization`.")
    public String getReturnAuthorizationId() {
        return this.returnAuthorizationId;
    }

    public void setReturnAuthorizationId(String returnAuthorizationId) {
        this.returnAuthorizationId = returnAuthorizationId;
    }

    public ReturnItem returnReceivedCondition(ReturnItemDisposition returnReceivedCondition) {
        this.returnReceivedCondition = returnReceivedCondition;
        return this;
    }

    @Schema(description="")
    public ReturnItemDisposition getReturnReceivedCondition() {
        return this.returnReceivedCondition;
    }

    public void setReturnReceivedCondition(ReturnItemDisposition returnReceivedCondition) {
        this.returnReceivedCondition = returnReceivedCondition;
    }

    public ReturnItem fulfillmentCenterId(String fulfillmentCenterId) {
        this.fulfillmentCenterId = fulfillmentCenterId;
        return this;
    }

    @Schema(description="The identifier for the Amazon fulfillment center that processed the return item.")
    public String getFulfillmentCenterId() {
        return this.fulfillmentCenterId;
    }

    public void setFulfillmentCenterId(String fulfillmentCenterId) {
        this.fulfillmentCenterId = fulfillmentCenterId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnItem returnItem = (ReturnItem)o;
        return Objects.equals(this.sellerReturnItemId, returnItem.sellerReturnItemId) && Objects.equals(this.sellerFulfillmentOrderItemId, returnItem.sellerFulfillmentOrderItemId) && Objects.equals(this.amazonShipmentId, returnItem.amazonShipmentId) && Objects.equals(this.sellerReturnReasonCode, returnItem.sellerReturnReasonCode) && Objects.equals(this.returnComment, returnItem.returnComment) && Objects.equals(this.amazonReturnReasonCode, returnItem.amazonReturnReasonCode) && Objects.equals((Object)this.status, (Object)returnItem.status) && Objects.equals(this.statusChangedDate, returnItem.statusChangedDate) && Objects.equals(this.returnAuthorizationId, returnItem.returnAuthorizationId) && Objects.equals((Object)this.returnReceivedCondition, (Object)returnItem.returnReceivedCondition) && Objects.equals(this.fulfillmentCenterId, returnItem.fulfillmentCenterId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sellerReturnItemId, this.sellerFulfillmentOrderItemId, this.amazonShipmentId, this.sellerReturnReasonCode, this.returnComment, this.amazonReturnReasonCode, this.status, this.statusChangedDate, this.returnAuthorizationId, this.returnReceivedCondition, this.fulfillmentCenterId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReturnItem {\n");
        sb.append("    sellerReturnItemId: ").append(this.toIndentedString(this.sellerReturnItemId)).append("\n");
        sb.append("    sellerFulfillmentOrderItemId: ").append(this.toIndentedString(this.sellerFulfillmentOrderItemId)).append("\n");
        sb.append("    amazonShipmentId: ").append(this.toIndentedString(this.amazonShipmentId)).append("\n");
        sb.append("    sellerReturnReasonCode: ").append(this.toIndentedString(this.sellerReturnReasonCode)).append("\n");
        sb.append("    returnComment: ").append(this.toIndentedString(this.returnComment)).append("\n");
        sb.append("    amazonReturnReasonCode: ").append(this.toIndentedString(this.amazonReturnReasonCode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusChangedDate: ").append(this.toIndentedString(this.statusChangedDate)).append("\n");
        sb.append("    returnAuthorizationId: ").append(this.toIndentedString(this.returnAuthorizationId)).append("\n");
        sb.append("    returnReceivedCondition: ").append(this.toIndentedString((Object)this.returnReceivedCondition)).append("\n");
        sb.append("    fulfillmentCenterId: ").append(this.toIndentedString(this.fulfillmentCenterId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

