/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.Address;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FeatureSettings;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.GetFulfillmentPreviewItemList;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.ShippingSpeedCategoryList;

@Schema(description="The request body schema for the `getFulfillmentPreview` operation.")
public class GetFulfillmentPreviewRequest {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="items")
    private GetFulfillmentPreviewItemList items = null;
    @SerializedName(value="shippingSpeedCategories")
    private ShippingSpeedCategoryList shippingSpeedCategories = null;
    @SerializedName(value="includeCODFulfillmentPreview")
    private Boolean includeCODFulfillmentPreview = null;
    @SerializedName(value="includeDeliveryWindows")
    private Boolean includeDeliveryWindows = null;
    @SerializedName(value="featureConstraints")
    private List<FeatureSettings> featureConstraints = null;

    public GetFulfillmentPreviewRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="The marketplace the fulfillment order is placed against.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public GetFulfillmentPreviewRequest address(Address address) {
        this.address = address;
        return this;
    }

    @Schema(required=true, description="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public GetFulfillmentPreviewRequest items(GetFulfillmentPreviewItemList items) {
        this.items = items;
        return this;
    }

    @Schema(required=true, description="")
    public GetFulfillmentPreviewItemList getItems() {
        return this.items;
    }

    public void setItems(GetFulfillmentPreviewItemList items) {
        this.items = items;
    }

    public GetFulfillmentPreviewRequest shippingSpeedCategories(ShippingSpeedCategoryList shippingSpeedCategories) {
        this.shippingSpeedCategories = shippingSpeedCategories;
        return this;
    }

    @Schema(description="")
    public ShippingSpeedCategoryList getShippingSpeedCategories() {
        return this.shippingSpeedCategories;
    }

    public void setShippingSpeedCategories(ShippingSpeedCategoryList shippingSpeedCategories) {
        this.shippingSpeedCategories = shippingSpeedCategories;
    }

    public GetFulfillmentPreviewRequest includeCODFulfillmentPreview(Boolean includeCODFulfillmentPreview) {
        this.includeCODFulfillmentPreview = includeCODFulfillmentPreview;
        return this;
    }

    @Schema(description="When true, returns all fulfillment order previews both for COD and not for COD. Otherwise, returns only fulfillment order previews that are not for COD.")
    public Boolean isIncludeCODFulfillmentPreview() {
        return this.includeCODFulfillmentPreview;
    }

    public void setIncludeCODFulfillmentPreview(Boolean includeCODFulfillmentPreview) {
        this.includeCODFulfillmentPreview = includeCODFulfillmentPreview;
    }

    public GetFulfillmentPreviewRequest includeDeliveryWindows(Boolean includeDeliveryWindows) {
        this.includeDeliveryWindows = includeDeliveryWindows;
        return this;
    }

    @Schema(description="When true, returns the `ScheduledDeliveryInfo` response object, which contains the available delivery windows for a Scheduled Delivery. The `ScheduledDeliveryInfo` response object can only be returned for fulfillment order previews with `ShippingSpeedCategories` equal to `ScheduledDelivery`.")
    public Boolean isIncludeDeliveryWindows() {
        return this.includeDeliveryWindows;
    }

    public void setIncludeDeliveryWindows(Boolean includeDeliveryWindows) {
        this.includeDeliveryWindows = includeDeliveryWindows;
    }

    public GetFulfillmentPreviewRequest featureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
        return this;
    }

    public GetFulfillmentPreviewRequest addFeatureConstraintsItem(FeatureSettings featureConstraintsItem) {
        if (this.featureConstraints == null) {
            this.featureConstraints = new ArrayList<FeatureSettings>();
        }
        this.featureConstraints.add(featureConstraintsItem);
        return this;
    }

    @Schema(description="A list of features and their fulfillment policies to apply to the order.")
    public List<FeatureSettings> getFeatureConstraints() {
        return this.featureConstraints;
    }

    public void setFeatureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetFulfillmentPreviewRequest getFulfillmentPreviewRequest = (GetFulfillmentPreviewRequest)o;
        return Objects.equals(this.marketplaceId, getFulfillmentPreviewRequest.marketplaceId) && Objects.equals(this.address, getFulfillmentPreviewRequest.address) && Objects.equals(this.items, getFulfillmentPreviewRequest.items) && Objects.equals(this.shippingSpeedCategories, getFulfillmentPreviewRequest.shippingSpeedCategories) && Objects.equals(this.includeCODFulfillmentPreview, getFulfillmentPreviewRequest.includeCODFulfillmentPreview) && Objects.equals(this.includeDeliveryWindows, getFulfillmentPreviewRequest.includeDeliveryWindows) && Objects.equals(this.featureConstraints, getFulfillmentPreviewRequest.featureConstraints);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.address, this.items, this.shippingSpeedCategories, this.includeCODFulfillmentPreview, this.includeDeliveryWindows, this.featureConstraints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetFulfillmentPreviewRequest {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    shippingSpeedCategories: ").append(this.toIndentedString(this.shippingSpeedCategories)).append("\n");
        sb.append("    includeCODFulfillmentPreview: ").append(this.toIndentedString(this.includeCODFulfillmentPreview)).append("\n");
        sb.append("    includeDeliveryWindows: ").append(this.toIndentedString(this.includeDeliveryWindows)).append("\n");
        sb.append("    featureConstraints: ").append(this.toIndentedString(this.featureConstraints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

