/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FeatureSku;

@Schema(description="The payload for the `getFeatureSKU` operation.")
public class GetFeatureSkuResult {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="featureName")
    private String featureName = null;
    @SerializedName(value="isEligible")
    private Boolean isEligible = null;
    @SerializedName(value="ineligibleReasons")
    private List<String> ineligibleReasons = null;
    @SerializedName(value="skuInfo")
    private FeatureSku skuInfo = null;

    public GetFeatureSkuResult marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="The requested marketplace.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public GetFeatureSkuResult featureName(String featureName) {
        this.featureName = featureName;
        return this;
    }

    @Schema(required=true, description="The name of the feature.")
    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public GetFeatureSkuResult isEligible(Boolean isEligible) {
        this.isEligible = isEligible;
        return this;
    }

    @Schema(required=true, description="When true, the seller SKU is eligible for the requested feature.")
    public Boolean isIsEligible() {
        return this.isEligible;
    }

    public void setIsEligible(Boolean isEligible) {
        this.isEligible = isEligible;
    }

    public GetFeatureSkuResult ineligibleReasons(List<String> ineligibleReasons) {
        this.ineligibleReasons = ineligibleReasons;
        return this;
    }

    public GetFeatureSkuResult addIneligibleReasonsItem(String ineligibleReasonsItem) {
        if (this.ineligibleReasons == null) {
            this.ineligibleReasons = new ArrayList<String>();
        }
        this.ineligibleReasons.add(ineligibleReasonsItem);
        return this;
    }

    @Schema(description="A list of one or more reasons that the seller SKU is ineligible for the feature.  Possible values: * `MERCHANT_NOT_ENROLLED`: The merchant isn't enrolled for the feature. * `SKU_NOT_ELIGIBLE`: The SKU doesn't reside in a warehouse that supports the feature. * `INVALID_SKU`: There is an issue with the SKU provided.")
    public List<String> getIneligibleReasons() {
        return this.ineligibleReasons;
    }

    public void setIneligibleReasons(List<String> ineligibleReasons) {
        this.ineligibleReasons = ineligibleReasons;
    }

    public GetFeatureSkuResult skuInfo(FeatureSku skuInfo) {
        this.skuInfo = skuInfo;
        return this;
    }

    @Schema(description="")
    public FeatureSku getSkuInfo() {
        return this.skuInfo;
    }

    public void setSkuInfo(FeatureSku skuInfo) {
        this.skuInfo = skuInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetFeatureSkuResult getFeatureSkuResult = (GetFeatureSkuResult)o;
        return Objects.equals(this.marketplaceId, getFeatureSkuResult.marketplaceId) && Objects.equals(this.featureName, getFeatureSkuResult.featureName) && Objects.equals(this.isEligible, getFeatureSkuResult.isEligible) && Objects.equals(this.ineligibleReasons, getFeatureSkuResult.ineligibleReasons) && Objects.equals(this.skuInfo, getFeatureSkuResult.skuInfo);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.featureName, this.isEligible, this.ineligibleReasons, this.skuInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetFeatureSkuResult {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    featureName: ").append(this.toIndentedString(this.featureName)).append("\n");
        sb.append("    isEligible: ").append(this.toIndentedString(this.isEligible)).append("\n");
        sb.append("    ineligibleReasons: ").append(this.toIndentedString(this.ineligibleReasons)).append("\n");
        sb.append("    skuInfo: ").append(this.toIndentedString(this.skuInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

