/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.DropOffLocation;

@Schema(description="The delivery preferences applied to the destination address. These preferences are applied when possible and are best effort. This feature is currently supported only in the JP marketplace and not applicable for other marketplaces. For eligible orders, the default delivery preference will be to deliver the package unattended at the front door, unless you specify otherwise.")
public class DeliveryPreferences {
    @SerializedName(value="deliveryInstructions")
    private String deliveryInstructions = null;
    @SerializedName(value="dropOffLocation")
    private DropOffLocation dropOffLocation = null;

    public DeliveryPreferences deliveryInstructions(String deliveryInstructions) {
        this.deliveryInstructions = deliveryInstructions;
        return this;
    }

    @Schema(description="Additional delivery instructions. For example, this could be instructions on how to enter a building, nearby landmark or navigation instructions, 'Beware of dogs', etc.")
    public String getDeliveryInstructions() {
        return this.deliveryInstructions;
    }

    public void setDeliveryInstructions(String deliveryInstructions) {
        this.deliveryInstructions = deliveryInstructions;
    }

    public DeliveryPreferences dropOffLocation(DropOffLocation dropOffLocation) {
        this.dropOffLocation = dropOffLocation;
        return this;
    }

    @Schema(description="")
    public DropOffLocation getDropOffLocation() {
        return this.dropOffLocation;
    }

    public void setDropOffLocation(DropOffLocation dropOffLocation) {
        this.dropOffLocation = dropOffLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryPreferences deliveryPreferences = (DeliveryPreferences)o;
        return Objects.equals(this.deliveryInstructions, deliveryPreferences.deliveryInstructions) && Objects.equals(this.dropOffLocation, deliveryPreferences.dropOffLocation);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryInstructions, this.dropOffLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeliveryPreferences {\n");
        sb.append("    deliveryInstructions: ").append(this.toIndentedString(this.deliveryInstructions)).append("\n");
        sb.append("    dropOffLocation: ").append(this.toIndentedString(this.dropOffLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

