/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Currency;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.TaxRate;

@Schema(description="Information used to determine the tax compliance.")
public class TaxDetails {
    @SerializedName(value="declaredValue")
    private Currency declaredValue = null;
    @SerializedName(value="hsnCode")
    private String hsnCode = null;
    @SerializedName(value="taxRates")
    private List<TaxRate> taxRates = null;

    public TaxDetails declaredValue(Currency declaredValue) {
        this.declaredValue = declaredValue;
        return this;
    }

    @Schema(description="")
    public Currency getDeclaredValue() {
        return this.declaredValue;
    }

    public void setDeclaredValue(Currency declaredValue) {
        this.declaredValue = declaredValue;
    }

    public TaxDetails hsnCode(String hsnCode) {
        this.hsnCode = hsnCode;
        return this;
    }

    @Schema(description="Harmonized System of Nomenclature code.")
    public String getHsnCode() {
        return this.hsnCode;
    }

    public void setHsnCode(String hsnCode) {
        this.hsnCode = hsnCode;
    }

    public TaxDetails taxRates(List<TaxRate> taxRates) {
        this.taxRates = taxRates;
        return this;
    }

    public TaxDetails addTaxRatesItem(TaxRate taxRatesItem) {
        if (this.taxRates == null) {
            this.taxRates = new ArrayList<TaxRate>();
        }
        this.taxRates.add(taxRatesItem);
        return this;
    }

    @Schema(description="List of tax rates.")
    public List<TaxRate> getTaxRates() {
        return this.taxRates;
    }

    public void setTaxRates(List<TaxRate> taxRates) {
        this.taxRates = taxRates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxDetails taxDetails = (TaxDetails)o;
        return Objects.equals(this.declaredValue, taxDetails.declaredValue) && Objects.equals(this.hsnCode, taxDetails.hsnCode) && Objects.equals(this.taxRates, taxDetails.taxRates);
    }

    public int hashCode() {
        return Objects.hash(this.declaredValue, this.hsnCode, this.taxRates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxDetails {\n");
        sb.append("    declaredValue: ").append(this.toIndentedString(this.declaredValue)).append("\n");
        sb.append("    hsnCode: ").append(this.toIndentedString(this.hsnCode)).append("\n");
        sb.append("    taxRates: ").append(this.toIndentedString(this.taxRates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

