/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The shipping configurations supported for the packing option. Available modes are ground small parcel, freight less-than-truckload (LTL), freight full-truckload (FTL) palletized, freight FTL non-palletized, ocean less-than-container-load (LCL), ocean full-container load (FCL), air small parcel, and air small parcel express.")
public class ShippingConfiguration {
    @SerializedName(value="shippingMode")
    private String shippingMode = null;
    @SerializedName(value="shippingSolution")
    private String shippingSolution = null;

    public ShippingConfiguration shippingMode(String shippingMode) {
        this.shippingMode = shippingMode;
        return this;
    }

    @Schema(description="Mode of shipment transportation that this option will provide.  Possible values: `GROUND_SMALL_PARCEL`, `FREIGHT_LTL`, `FREIGHT_FTL_PALLET`, `FREIGHT_FTL_NONPALLET`, `OCEAN_LCL`, `OCEAN_FCL`, `AIR_SMALL_PARCEL`, `AIR_SMALL_PARCEL_EXPRESS`.")
    public String getShippingMode() {
        return this.shippingMode;
    }

    public void setShippingMode(String shippingMode) {
        this.shippingMode = shippingMode;
    }

    public ShippingConfiguration shippingSolution(String shippingSolution) {
        this.shippingSolution = shippingSolution;
        return this;
    }

    @Schema(description="Shipping program for the option. Possible values: `AMAZON_PARTNERED_CARRIER`, `USE_YOUR_OWN_CARRIER`.")
    public String getShippingSolution() {
        return this.shippingSolution;
    }

    public void setShippingSolution(String shippingSolution) {
        this.shippingSolution = shippingSolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingConfiguration shippingConfiguration = (ShippingConfiguration)o;
        return Objects.equals(this.shippingMode, shippingConfiguration.shippingMode) && Objects.equals(this.shippingSolution, shippingConfiguration.shippingSolution);
    }

    public int hashCode() {
        return Objects.hash(this.shippingMode, this.shippingSolution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingConfiguration {\n");
        sb.append("    shippingMode: ").append(this.toIndentedString(this.shippingMode)).append("\n");
        sb.append("    shippingSolution: ").append(this.toIndentedString(this.shippingSolution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

