/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Representation of a location used within the inbounding experience.")
public class Region {
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="warehouseId")
    private String warehouseId = null;

    public Region countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(description="ISO 3166 standard alpha-2 country code.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public Region state(String state) {
        this.state = state;
        return this;
    }

    @Schema(description="State.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Region warehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
        return this;
    }

    @Schema(description="An identifier for a warehouse, such as a FC, IXD, upstream storage.")
    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return Objects.equals(this.countryCode, region.countryCode) && Objects.equals(this.state, region.state) && Objects.equals(this.warehouseId, region.warehouseId);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.state, this.warehouseId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Region {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    warehouseId: ").append(this.toIndentedString(this.warehouseId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

