/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Currency;

@Schema(description="The estimated shipping cost associated with the transportation option.")
public class Quote {
    @SerializedName(value="cost")
    private Currency cost = null;
    @SerializedName(value="expiration")
    private OffsetDateTime expiration = null;
    @SerializedName(value="voidableUntil")
    private OffsetDateTime voidableUntil = null;

    public Quote cost(Currency cost) {
        this.cost = cost;
        return this;
    }

    @Schema(required=true, description="")
    public Currency getCost() {
        return this.cost;
    }

    public void setCost(Currency cost) {
        this.cost = cost;
    }

    public Quote expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The time at which this transportation option quote expires. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime with pattern `yyyy-MM-ddTHH:mm:ss.sssZ`.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public Quote voidableUntil(OffsetDateTime voidableUntil) {
        this.voidableUntil = voidableUntil;
        return this;
    }

    @Schema(description="Voidable until timestamp.")
    public OffsetDateTime getVoidableUntil() {
        return this.voidableUntil;
    }

    public void setVoidableUntil(OffsetDateTime voidableUntil) {
        this.voidableUntil = voidableUntil;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quote quote = (Quote)o;
        return Objects.equals(this.cost, quote.cost) && Objects.equals(this.expiration, quote.expiration) && Objects.equals(this.voidableUntil, quote.voidableUntil);
    }

    public int hashCode() {
        return Objects.hash(this.cost, this.expiration, this.voidableUntil);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Quote {\n");
        sb.append("    cost: ").append(this.toIndentedString(this.cost)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    voidableUntil: ").append(this.toIndentedString(this.voidableUntil)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

