/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.BoxInput;

@Schema(description="Packing information for the inbound plan.")
public class PackageGroupingInput {
    @SerializedName(value="boxes")
    private List<BoxInput> boxes = new ArrayList<BoxInput>();
    @SerializedName(value="packingGroupId")
    private String packingGroupId = null;
    @SerializedName(value="shipmentId")
    private String shipmentId = null;

    public PackageGroupingInput boxes(List<BoxInput> boxes) {
        this.boxes = boxes;
        return this;
    }

    public PackageGroupingInput addBoxesItem(BoxInput boxesItem) {
        this.boxes.add(boxesItem);
        return this;
    }

    @Schema(required=true, description="Box level information being provided.")
    public List<BoxInput> getBoxes() {
        return this.boxes;
    }

    public void setBoxes(List<BoxInput> boxes) {
        this.boxes = boxes;
    }

    public PackageGroupingInput packingGroupId(String packingGroupId) {
        this.packingGroupId = packingGroupId;
        return this;
    }

    @Schema(description="The ID of the `packingGroup` that packages are grouped according to. The `PackingGroupId` can only be provided before placement confirmation, and it must belong to the confirmed `PackingOption`. One of `ShipmentId` or `PackingGroupId` must be provided with every request.")
    public String getPackingGroupId() {
        return this.packingGroupId;
    }

    public void setPackingGroupId(String packingGroupId) {
        this.packingGroupId = packingGroupId;
    }

    public PackageGroupingInput shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(description="The ID of the shipment that packages are grouped according to. The `ShipmentId` can only be provided after placement confirmation, and the shipment must belong to the confirmed placement option. One of `ShipmentId` or `PackingGroupId` must be provided with every request.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageGroupingInput packageGroupingInput = (PackageGroupingInput)o;
        return Objects.equals(this.boxes, packageGroupingInput.boxes) && Objects.equals(this.packingGroupId, packageGroupingInput.packingGroupId) && Objects.equals(this.shipmentId, packageGroupingInput.shipmentId);
    }

    public int hashCode() {
        return Objects.hash(this.boxes, this.packingGroupId, this.shipmentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackageGroupingInput {\n");
        sb.append("    boxes: ").append(this.toIndentedString(this.boxes)).append("\n");
        sb.append("    packingGroupId: ").append(this.toIndentedString(this.packingGroupId)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

