/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PrepCategory;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PrepType;

@Schema(description="An MSKU and its related prep details.")
public class MskuPrepDetailInput {
    @SerializedName(value="msku")
    private String msku = null;
    @SerializedName(value="prepCategory")
    private PrepCategory prepCategory = null;
    @SerializedName(value="prepTypes")
    private List<PrepType> prepTypes = new ArrayList<PrepType>();

    public MskuPrepDetailInput msku(String msku) {
        this.msku = msku;
        return this;
    }

    @Schema(required=true, description="The merchant SKU, a merchant-supplied identifier for a specific SKU.")
    public String getMsku() {
        return this.msku;
    }

    public void setMsku(String msku) {
        this.msku = msku;
    }

    public MskuPrepDetailInput prepCategory(PrepCategory prepCategory) {
        this.prepCategory = prepCategory;
        return this;
    }

    @Schema(required=true, description="")
    public PrepCategory getPrepCategory() {
        return this.prepCategory;
    }

    public void setPrepCategory(PrepCategory prepCategory) {
        this.prepCategory = prepCategory;
    }

    public MskuPrepDetailInput prepTypes(List<PrepType> prepTypes) {
        this.prepTypes = prepTypes;
        return this;
    }

    public MskuPrepDetailInput addPrepTypesItem(PrepType prepTypesItem) {
        this.prepTypes.add(prepTypesItem);
        return this;
    }

    @Schema(required=true, description="A list of preparation types associated with a preparation category.")
    public List<PrepType> getPrepTypes() {
        return this.prepTypes;
    }

    public void setPrepTypes(List<PrepType> prepTypes) {
        this.prepTypes = prepTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MskuPrepDetailInput mskuPrepDetailInput = (MskuPrepDetailInput)o;
        return Objects.equals(this.msku, mskuPrepDetailInput.msku) && Objects.equals((Object)this.prepCategory, (Object)mskuPrepDetailInput.prepCategory) && Objects.equals(this.prepTypes, mskuPrepDetailInput.prepTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.msku, this.prepCategory, this.prepTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MskuPrepDetailInput {\n");
        sb.append("    msku: ").append(this.toIndentedString(this.msku)).append("\n");
        sb.append("    prepCategory: ").append(this.toIndentedString((Object)this.prepCategory)).append("\n");
        sb.append("    prepTypes: ").append(this.toIndentedString(this.prepTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

