/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ShipmentTransportationConfiguration;

@Schema(description="The `generateTransportationOptions` request.")
public class GenerateTransportationOptionsRequest {
    @SerializedName(value="placementOptionId")
    private String placementOptionId = null;
    @SerializedName(value="shipmentTransportationConfigurations")
    private List<ShipmentTransportationConfiguration> shipmentTransportationConfigurations = new ArrayList<ShipmentTransportationConfiguration>();

    public GenerateTransportationOptionsRequest placementOptionId(String placementOptionId) {
        this.placementOptionId = placementOptionId;
        return this;
    }

    @Schema(required=true, description="The placement option to generate transportation options for.")
    public String getPlacementOptionId() {
        return this.placementOptionId;
    }

    public void setPlacementOptionId(String placementOptionId) {
        this.placementOptionId = placementOptionId;
    }

    public GenerateTransportationOptionsRequest shipmentTransportationConfigurations(List<ShipmentTransportationConfiguration> shipmentTransportationConfigurations) {
        this.shipmentTransportationConfigurations = shipmentTransportationConfigurations;
        return this;
    }

    public GenerateTransportationOptionsRequest addShipmentTransportationConfigurationsItem(ShipmentTransportationConfiguration shipmentTransportationConfigurationsItem) {
        this.shipmentTransportationConfigurations.add(shipmentTransportationConfigurationsItem);
        return this;
    }

    @Schema(required=true, description="List of shipment transportation configurations.")
    public List<ShipmentTransportationConfiguration> getShipmentTransportationConfigurations() {
        return this.shipmentTransportationConfigurations;
    }

    public void setShipmentTransportationConfigurations(List<ShipmentTransportationConfiguration> shipmentTransportationConfigurations) {
        this.shipmentTransportationConfigurations = shipmentTransportationConfigurations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateTransportationOptionsRequest generateTransportationOptionsRequest = (GenerateTransportationOptionsRequest)o;
        return Objects.equals(this.placementOptionId, generateTransportationOptionsRequest.placementOptionId) && Objects.equals(this.shipmentTransportationConfigurations, generateTransportationOptionsRequest.shipmentTransportationConfigurations);
    }

    public int hashCode() {
        return Objects.hash(this.placementOptionId, this.shipmentTransportationConfigurations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenerateTransportationOptionsRequest {\n");
        sb.append("    placementOptionId: ").append(this.toIndentedString(this.placementOptionId)).append("\n");
        sb.append("    shipmentTransportationConfigurations: ").append(this.toIndentedString(this.shipmentTransportationConfigurations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

