/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Currency;

@Schema(description="Freight information describes the SKUs that are in transit. Freight carrier options and quotes will only be returned if the freight information is provided.")
public class FreightInformation {
    @SerializedName(value="declaredValue")
    private Currency declaredValue = null;
    @SerializedName(value="freightClass")
    private String freightClass = null;

    public FreightInformation declaredValue(Currency declaredValue) {
        this.declaredValue = declaredValue;
        return this;
    }

    @Schema(description="")
    public Currency getDeclaredValue() {
        return this.declaredValue;
    }

    public void setDeclaredValue(Currency declaredValue) {
        this.declaredValue = declaredValue;
    }

    public FreightInformation freightClass(String freightClass) {
        this.freightClass = freightClass;
        return this;
    }

    @Schema(description="Freight class.  Possible values: `NONE`, `FC_50`, `FC_55`, `FC_60`, `FC_65`, `FC_70`, `FC_77_5`, `FC_85`, `FC_92_5`, `FC_100`, `FC_110`, `FC_125`, `FC_150`, `FC_175`, `FC_200`, `FC_250`, `FC_300`, `FC_400`, `FC_500`.")
    public String getFreightClass() {
        return this.freightClass;
    }

    public void setFreightClass(String freightClass) {
        this.freightClass = freightClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FreightInformation freightInformation = (FreightInformation)o;
        return Objects.equals(this.declaredValue, freightInformation.declaredValue) && Objects.equals(this.freightClass, freightInformation.freightClass);
    }

    public int hashCode() {
        return Objects.hash(this.declaredValue, this.freightClass);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FreightInformation {\n");
        sb.append("    declaredValue: ").append(this.toIndentedString(this.declaredValue)).append("\n");
        sb.append("    freightClass: ").append(this.toIndentedString(this.freightClass)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

