/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Contains information pertaining to a delivery window option.")
public class DeliveryWindowOption {
    @SerializedName(value="availabilityType")
    private String availabilityType = null;
    @SerializedName(value="deliveryWindowOptionId")
    private String deliveryWindowOptionId = null;
    @SerializedName(value="endDate")
    private OffsetDateTime endDate = null;
    @SerializedName(value="startDate")
    private OffsetDateTime startDate = null;
    @SerializedName(value="validUntil")
    private OffsetDateTime validUntil = null;

    public DeliveryWindowOption availabilityType(String availabilityType) {
        this.availabilityType = availabilityType;
        return this;
    }

    @Schema(required=true, description="Identifies type of Delivery Window Availability. Values: `AVAILABLE`, `CONGESTED`")
    public String getAvailabilityType() {
        return this.availabilityType;
    }

    public void setAvailabilityType(String availabilityType) {
        this.availabilityType = availabilityType;
    }

    public DeliveryWindowOption deliveryWindowOptionId(String deliveryWindowOptionId) {
        this.deliveryWindowOptionId = deliveryWindowOptionId;
        return this;
    }

    @Schema(required=true, description="Identifier of a delivery window option. A delivery window option represent one option for when a shipment is expected to be delivered.")
    public String getDeliveryWindowOptionId() {
        return this.deliveryWindowOptionId;
    }

    public void setDeliveryWindowOptionId(String deliveryWindowOptionId) {
        this.deliveryWindowOptionId = deliveryWindowOptionId;
    }

    public DeliveryWindowOption endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Schema(required=true, description="The time at which this delivery window option ends. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mmZ`.")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public DeliveryWindowOption startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(required=true, description="The time at which this delivery window option starts. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mmZ`.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public DeliveryWindowOption validUntil(OffsetDateTime validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    @Schema(required=true, description="The time at which this window delivery option is no longer valid. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mmZ`.")
    public OffsetDateTime getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(OffsetDateTime validUntil) {
        this.validUntil = validUntil;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryWindowOption deliveryWindowOption = (DeliveryWindowOption)o;
        return Objects.equals(this.availabilityType, deliveryWindowOption.availabilityType) && Objects.equals(this.deliveryWindowOptionId, deliveryWindowOption.deliveryWindowOptionId) && Objects.equals(this.endDate, deliveryWindowOption.endDate) && Objects.equals(this.startDate, deliveryWindowOption.startDate) && Objects.equals(this.validUntil, deliveryWindowOption.validUntil);
    }

    public int hashCode() {
        return Objects.hash(this.availabilityType, this.deliveryWindowOptionId, this.endDate, this.startDate, this.validUntil);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeliveryWindowOption {\n");
        sb.append("    availabilityType: ").append(this.toIndentedString(this.availabilityType)).append("\n");
        sb.append("    deliveryWindowOptionId: ").append(this.toIndentedString(this.deliveryWindowOptionId)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    validUntil: ").append(this.toIndentedString(this.validUntil)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

