/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ItemLabelPageType;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.LabelPrintType;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.MskuQuantity;

@Schema(description="The `createMarketplaceItemLabels` request.")
public class CreateMarketplaceItemLabelsRequest {
    @SerializedName(value="height")
    private BigDecimal height = null;
    @SerializedName(value="labelType")
    private LabelPrintType labelType = null;
    @SerializedName(value="localeCode")
    private String localeCode = "en_US";
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="mskuQuantities")
    private List<MskuQuantity> mskuQuantities = new ArrayList<MskuQuantity>();
    @SerializedName(value="pageType")
    private ItemLabelPageType pageType = null;
    @SerializedName(value="width")
    private BigDecimal width = null;

    public CreateMarketplaceItemLabelsRequest height(BigDecimal height) {
        this.height = height;
        return this;
    }

    @Schema(description="The height of the item label.")
    public BigDecimal getHeight() {
        return this.height;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public CreateMarketplaceItemLabelsRequest labelType(LabelPrintType labelType) {
        this.labelType = labelType;
        return this;
    }

    @Schema(required=true, description="")
    public LabelPrintType getLabelType() {
        return this.labelType;
    }

    public void setLabelType(LabelPrintType labelType) {
        this.labelType = labelType;
    }

    public CreateMarketplaceItemLabelsRequest localeCode(String localeCode) {
        this.localeCode = localeCode;
        return this;
    }

    @Schema(description="The locale code constructed from ISO 639 language code and ISO 3166-1 alpha-2 standard of country codes separated by an underscore character.")
    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public CreateMarketplaceItemLabelsRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids).")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public CreateMarketplaceItemLabelsRequest mskuQuantities(List<MskuQuantity> mskuQuantities) {
        this.mskuQuantities = mskuQuantities;
        return this;
    }

    public CreateMarketplaceItemLabelsRequest addMskuQuantitiesItem(MskuQuantity mskuQuantitiesItem) {
        this.mskuQuantities.add(mskuQuantitiesItem);
        return this;
    }

    @Schema(required=true, description="Represents the quantity of an MSKU to print item labels for.")
    public List<MskuQuantity> getMskuQuantities() {
        return this.mskuQuantities;
    }

    public void setMskuQuantities(List<MskuQuantity> mskuQuantities) {
        this.mskuQuantities = mskuQuantities;
    }

    public CreateMarketplaceItemLabelsRequest pageType(ItemLabelPageType pageType) {
        this.pageType = pageType;
        return this;
    }

    @Schema(description="")
    public ItemLabelPageType getPageType() {
        return this.pageType;
    }

    public void setPageType(ItemLabelPageType pageType) {
        this.pageType = pageType;
    }

    public CreateMarketplaceItemLabelsRequest width(BigDecimal width) {
        this.width = width;
        return this;
    }

    @Schema(description="The width of the item label.")
    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMarketplaceItemLabelsRequest createMarketplaceItemLabelsRequest = (CreateMarketplaceItemLabelsRequest)o;
        return Objects.equals(this.height, createMarketplaceItemLabelsRequest.height) && Objects.equals((Object)this.labelType, (Object)createMarketplaceItemLabelsRequest.labelType) && Objects.equals(this.localeCode, createMarketplaceItemLabelsRequest.localeCode) && Objects.equals(this.marketplaceId, createMarketplaceItemLabelsRequest.marketplaceId) && Objects.equals(this.mskuQuantities, createMarketplaceItemLabelsRequest.mskuQuantities) && Objects.equals((Object)this.pageType, (Object)createMarketplaceItemLabelsRequest.pageType) && Objects.equals(this.width, createMarketplaceItemLabelsRequest.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.height, this.labelType, this.localeCode, this.marketplaceId, this.mskuQuantities, this.pageType, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMarketplaceItemLabelsRequest {\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    labelType: ").append(this.toIndentedString((Object)this.labelType)).append("\n");
        sb.append("    localeCode: ").append(this.toIndentedString(this.localeCode)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    mskuQuantities: ").append(this.toIndentedString(this.mskuQuantities)).append("\n");
        sb.append("    pageType: ").append(this.toIndentedString((Object)this.pageType)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

