/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.BoxContentInformationSource;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Dimensions;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ItemInput;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Weight;

@Schema(description="Input information for updating a box")
public class BoxUpdateInput {
    @SerializedName(value="contentInformationSource")
    private BoxContentInformationSource contentInformationSource = null;
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="items")
    private List<ItemInput> items = null;
    @SerializedName(value="packageId")
    private String packageId = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="weight")
    private Weight weight = null;

    public BoxUpdateInput contentInformationSource(BoxContentInformationSource contentInformationSource) {
        this.contentInformationSource = contentInformationSource;
        return this;
    }

    @Schema(required=true, description="")
    public BoxContentInformationSource getContentInformationSource() {
        return this.contentInformationSource;
    }

    public void setContentInformationSource(BoxContentInformationSource contentInformationSource) {
        this.contentInformationSource = contentInformationSource;
    }

    public BoxUpdateInput dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(required=true, description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public BoxUpdateInput items(List<ItemInput> items) {
        this.items = items;
        return this;
    }

    public BoxUpdateInput addItemsItem(ItemInput itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<ItemInput>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Schema(description="The items and their quantity in the box. This must be empty if the box `contentInformationSource` is `BARCODE_2D` or `MANUAL_PROCESS`.")
    public List<ItemInput> getItems() {
        return this.items;
    }

    public void setItems(List<ItemInput> items) {
        this.items = items;
    }

    public BoxUpdateInput packageId(String packageId) {
        this.packageId = packageId;
        return this;
    }

    @Schema(description="Primary key to uniquely identify a Box Package. PackageId must be provided if the intent is to update an existing box. Adding a new box will not require providing this value. Any existing PackageIds not provided will be treated as to-be-removed")
    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public BoxUpdateInput quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(required=true, description="The number of containers where all other properties like weight or dimensions are identical.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public BoxUpdateInput weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(required=true, description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxUpdateInput boxUpdateInput = (BoxUpdateInput)o;
        return Objects.equals((Object)this.contentInformationSource, (Object)boxUpdateInput.contentInformationSource) && Objects.equals(this.dimensions, boxUpdateInput.dimensions) && Objects.equals(this.items, boxUpdateInput.items) && Objects.equals(this.packageId, boxUpdateInput.packageId) && Objects.equals(this.quantity, boxUpdateInput.quantity) && Objects.equals(this.weight, boxUpdateInput.weight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentInformationSource, this.dimensions, this.items, this.packageId, this.quantity, this.weight});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BoxUpdateInput {\n");
        sb.append("    contentInformationSource: ").append(this.toIndentedString((Object)this.contentInformationSource)).append("\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    packageId: ").append(this.toIndentedString(this.packageId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

