/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Additional information related to the product.")
public class ProductContext {
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="quantityShipped")
    private Integer quantityShipped = null;
    @SerializedName(value="fulfillmentNetwork")
    private String fulfillmentNetwork = null;

    public ProductContext asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) of the item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public ProductContext sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(description="Stock keeping unit (SKU) of the item.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public ProductContext quantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
        return this;
    }

    @Schema(description="Quantity of the item shipped.")
    public Integer getQuantityShipped() {
        return this.quantityShipped;
    }

    public void setQuantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
    }

    public ProductContext fulfillmentNetwork(String fulfillmentNetwork) {
        this.fulfillmentNetwork = fulfillmentNetwork;
        return this;
    }

    @Schema(description="Fulfillment network of the item.")
    public String getFulfillmentNetwork() {
        return this.fulfillmentNetwork;
    }

    public void setFulfillmentNetwork(String fulfillmentNetwork) {
        this.fulfillmentNetwork = fulfillmentNetwork;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductContext productContext = (ProductContext)o;
        return Objects.equals(this.asin, productContext.asin) && Objects.equals(this.sku, productContext.sku) && Objects.equals(this.quantityShipped, productContext.quantityShipped) && Objects.equals(this.fulfillmentNetwork, productContext.fulfillmentNetwork);
    }

    public int hashCode() {
        return Objects.hash(this.asin, this.sku, this.quantityShipped, this.fulfillmentNetwork);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductContext {\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    quantityShipped: ").append(this.toIndentedString(this.quantityShipped)).append("\n");
        sb.append("    fulfillmentNetwork: ").append(this.toIndentedString(this.fulfillmentNetwork)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

