/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Additional information related to Payments related transactions.")
public class PaymentsContext {
    @SerializedName(value="paymentType")
    private String paymentType = null;
    @SerializedName(value="paymentMethod")
    private String paymentMethod = null;
    @SerializedName(value="paymentReference")
    private String paymentReference = null;
    @SerializedName(value="paymentDate")
    private OffsetDateTime paymentDate = null;

    public PaymentsContext paymentType(String paymentType) {
        this.paymentType = paymentType;
        return this;
    }

    @Schema(description="Type of payment made.")
    public String getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public PaymentsContext paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="Method of payment made.")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentsContext paymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
        return this;
    }

    @Schema(description="Reference number of payment made.")
    public String getPaymentReference() {
        return this.paymentReference;
    }

    public void setPaymentReference(String paymentReference) {
        this.paymentReference = paymentReference;
    }

    public PaymentsContext paymentDate(OffsetDateTime paymentDate) {
        this.paymentDate = paymentDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(OffsetDateTime paymentDate) {
        this.paymentDate = paymentDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentsContext paymentsContext = (PaymentsContext)o;
        return Objects.equals(this.paymentType, paymentsContext.paymentType) && Objects.equals(this.paymentMethod, paymentsContext.paymentMethod) && Objects.equals(this.paymentReference, paymentsContext.paymentReference) && Objects.equals(this.paymentDate, paymentsContext.paymentDate);
    }

    public int hashCode() {
        return Objects.hash(this.paymentType, this.paymentMethod, this.paymentReference, this.paymentDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentsContext {\n");
        sb.append("    paymentType: ").append(this.toIndentedString(this.paymentType)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentReference: ").append(this.toIndentedString(this.paymentReference)).append("\n");
        sb.append("    paymentDate: ").append(this.toIndentedString(this.paymentDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

