/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.finances.v2024_06_19.Breakdown;
import software.amazon.spapi.models.finances.v2024_06_19.Contexts;
import software.amazon.spapi.models.finances.v2024_06_19.Currency;
import software.amazon.spapi.models.finances.v2024_06_19.ItemRelatedIdentifiers;

@Schema(description="Additional information about the items in Transaction.")
public class Item {
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="relatedIdentifiers")
    private ItemRelatedIdentifiers relatedIdentifiers = null;
    @SerializedName(value="totalAmount")
    private Currency totalAmount = null;
    @SerializedName(value="breakdowns")
    private List<Breakdown> breakdowns = null;
    @SerializedName(value="contexts")
    private Contexts contexts = null;

    public Item description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="Description of items in the transaction")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Item relatedIdentifiers(ItemRelatedIdentifiers relatedIdentifiers) {
        this.relatedIdentifiers = relatedIdentifiers;
        return this;
    }

    @Schema(description="")
    public ItemRelatedIdentifiers getRelatedIdentifiers() {
        return this.relatedIdentifiers;
    }

    public void setRelatedIdentifiers(ItemRelatedIdentifiers relatedIdentifiers) {
        this.relatedIdentifiers = relatedIdentifiers;
    }

    public Item totalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @Schema(description="")
    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Item breakdowns(List<Breakdown> breakdowns) {
        this.breakdowns = breakdowns;
        return this;
    }

    public Item addBreakdownsItem(Breakdown breakdownsItem) {
        if (this.breakdowns == null) {
            this.breakdowns = new ArrayList<Breakdown>();
        }
        this.breakdowns.add(breakdownsItem);
        return this;
    }

    @Schema(description="A list of breakdowns that detail how the total amount is calculated for the transaction.")
    public List<Breakdown> getBreakdowns() {
        return this.breakdowns;
    }

    public void setBreakdowns(List<Breakdown> breakdowns) {
        this.breakdowns = breakdowns;
    }

    public Item contexts(Contexts contexts) {
        this.contexts = contexts;
        return this;
    }

    @Schema(description="")
    public Contexts getContexts() {
        return this.contexts;
    }

    public void setContexts(Contexts contexts) {
        this.contexts = contexts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.description, item.description) && Objects.equals(this.relatedIdentifiers, item.relatedIdentifiers) && Objects.equals(this.totalAmount, item.totalAmount) && Objects.equals(this.breakdowns, item.breakdowns) && Objects.equals(this.contexts, item.contexts);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.relatedIdentifiers, this.totalAmount, this.breakdowns, this.contexts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    relatedIdentifiers: ").append(this.toIndentedString(this.relatedIdentifiers)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    breakdowns: ").append(this.toIndentedString(this.breakdowns)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

