/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v2024_06_19;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="Information about the line of business associated with a transaction.")
public class BusinessContext {
    @SerializedName(value="storeName")
    private StoreNameEnum storeName = null;

    public BusinessContext storeName(StoreNameEnum storeName) {
        this.storeName = storeName;
        return this;
    }

    @Schema(description="The store name associated with the transaction.")
    public StoreNameEnum getStoreName() {
        return this.storeName;
    }

    public void setStoreName(StoreNameEnum storeName) {
        this.storeName = storeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessContext businessContext = (BusinessContext)o;
        return Objects.equals((Object)this.storeName, (Object)businessContext.storeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.storeName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessContext {\n");
        sb.append("    storeName: ").append(this.toIndentedString((Object)this.storeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StoreNameEnum {
        AMAZON_HAUL("AMAZON_HAUL");

        private String value;

        private StoreNameEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StoreNameEnum fromValue(String input) {
            for (StoreNameEnum b : StoreNameEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StoreNameEnum> {
            public void write(JsonWriter jsonWriter, StoreNameEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StoreNameEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StoreNameEnum.fromValue(value);
            }
        }
    }
}

