/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="An event related to a Tax-Deducted-at-Source (TDS) reimbursement.")
public class TDSReimbursementEvent {
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="TDSOrderId")
    private String tdSOrderId = null;
    @SerializedName(value="ReimbursedAmount")
    private Currency reimbursedAmount = null;

    public TDSReimbursementEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public TDSReimbursementEvent tdSOrderId(String tdSOrderId) {
        this.tdSOrderId = tdSOrderId;
        return this;
    }

    @Schema(description="The Tax-Deducted-at-Source (TDS) identifier.")
    public String getTdSOrderId() {
        return this.tdSOrderId;
    }

    public void setTdSOrderId(String tdSOrderId) {
        this.tdSOrderId = tdSOrderId;
    }

    public TDSReimbursementEvent reimbursedAmount(Currency reimbursedAmount) {
        this.reimbursedAmount = reimbursedAmount;
        return this;
    }

    @Schema(description="")
    public Currency getReimbursedAmount() {
        return this.reimbursedAmount;
    }

    public void setReimbursedAmount(Currency reimbursedAmount) {
        this.reimbursedAmount = reimbursedAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TDSReimbursementEvent tdSReimbursementEvent = (TDSReimbursementEvent)o;
        return Objects.equals(this.postedDate, tdSReimbursementEvent.postedDate) && Objects.equals(this.tdSOrderId, tdSReimbursementEvent.tdSOrderId) && Objects.equals(this.reimbursedAmount, tdSReimbursementEvent.reimbursedAmount);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.tdSOrderId, this.reimbursedAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TDSReimbursementEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    tdSOrderId: ").append(this.toIndentedString(this.tdSOrderId)).append("\n");
        sb.append("    reimbursedAmount: ").append(this.toIndentedString(this.reimbursedAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

