/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.finances.v0.ChargeComponentList;
import software.amazon.spapi.models.finances.v0.Currency;
import software.amazon.spapi.models.finances.v0.FeeComponentList;
import software.amazon.spapi.models.finances.v0.PromotionList;
import software.amazon.spapi.models.finances.v0.TaxWithheldComponentList;

@Schema(description="An item of a shipment, refund, guarantee claim, or chargeback.")
public class ShipmentItem {
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="OrderAdjustmentItemId")
    private String orderAdjustmentItemId = null;
    @SerializedName(value="QuantityShipped")
    private Integer quantityShipped = null;
    @SerializedName(value="ItemChargeList")
    private ChargeComponentList itemChargeList = null;
    @SerializedName(value="ItemChargeAdjustmentList")
    private ChargeComponentList itemChargeAdjustmentList = null;
    @SerializedName(value="ItemFeeList")
    private FeeComponentList itemFeeList = null;
    @SerializedName(value="ItemFeeAdjustmentList")
    private FeeComponentList itemFeeAdjustmentList = null;
    @SerializedName(value="ItemTaxWithheldList")
    private TaxWithheldComponentList itemTaxWithheldList = null;
    @SerializedName(value="PromotionList")
    private PromotionList promotionList = null;
    @SerializedName(value="PromotionAdjustmentList")
    private PromotionList promotionAdjustmentList = null;
    @SerializedName(value="CostOfPointsGranted")
    private Currency costOfPointsGranted = null;
    @SerializedName(value="CostOfPointsReturned")
    private Currency costOfPointsReturned = null;

    public ShipmentItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @Schema(description="The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public ShipmentItem orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @Schema(description="An Amazon-defined order item identifier.")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public ShipmentItem orderAdjustmentItemId(String orderAdjustmentItemId) {
        this.orderAdjustmentItemId = orderAdjustmentItemId;
        return this;
    }

    @Schema(description="An Amazon-defined order adjustment identifier defined for refunds, guarantee claims, and chargeback events.")
    public String getOrderAdjustmentItemId() {
        return this.orderAdjustmentItemId;
    }

    public void setOrderAdjustmentItemId(String orderAdjustmentItemId) {
        this.orderAdjustmentItemId = orderAdjustmentItemId;
    }

    public ShipmentItem quantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
        return this;
    }

    @Schema(description="The number of items shipped.")
    public Integer getQuantityShipped() {
        return this.quantityShipped;
    }

    public void setQuantityShipped(Integer quantityShipped) {
        this.quantityShipped = quantityShipped;
    }

    public ShipmentItem itemChargeList(ChargeComponentList itemChargeList) {
        this.itemChargeList = itemChargeList;
        return this;
    }

    @Schema(description="")
    public ChargeComponentList getItemChargeList() {
        return this.itemChargeList;
    }

    public void setItemChargeList(ChargeComponentList itemChargeList) {
        this.itemChargeList = itemChargeList;
    }

    public ShipmentItem itemChargeAdjustmentList(ChargeComponentList itemChargeAdjustmentList) {
        this.itemChargeAdjustmentList = itemChargeAdjustmentList;
        return this;
    }

    @Schema(description="")
    public ChargeComponentList getItemChargeAdjustmentList() {
        return this.itemChargeAdjustmentList;
    }

    public void setItemChargeAdjustmentList(ChargeComponentList itemChargeAdjustmentList) {
        this.itemChargeAdjustmentList = itemChargeAdjustmentList;
    }

    public ShipmentItem itemFeeList(FeeComponentList itemFeeList) {
        this.itemFeeList = itemFeeList;
        return this;
    }

    @Schema(description="")
    public FeeComponentList getItemFeeList() {
        return this.itemFeeList;
    }

    public void setItemFeeList(FeeComponentList itemFeeList) {
        this.itemFeeList = itemFeeList;
    }

    public ShipmentItem itemFeeAdjustmentList(FeeComponentList itemFeeAdjustmentList) {
        this.itemFeeAdjustmentList = itemFeeAdjustmentList;
        return this;
    }

    @Schema(description="")
    public FeeComponentList getItemFeeAdjustmentList() {
        return this.itemFeeAdjustmentList;
    }

    public void setItemFeeAdjustmentList(FeeComponentList itemFeeAdjustmentList) {
        this.itemFeeAdjustmentList = itemFeeAdjustmentList;
    }

    public ShipmentItem itemTaxWithheldList(TaxWithheldComponentList itemTaxWithheldList) {
        this.itemTaxWithheldList = itemTaxWithheldList;
        return this;
    }

    @Schema(description="")
    public TaxWithheldComponentList getItemTaxWithheldList() {
        return this.itemTaxWithheldList;
    }

    public void setItemTaxWithheldList(TaxWithheldComponentList itemTaxWithheldList) {
        this.itemTaxWithheldList = itemTaxWithheldList;
    }

    public ShipmentItem promotionList(PromotionList promotionList) {
        this.promotionList = promotionList;
        return this;
    }

    @Schema(description="")
    public PromotionList getPromotionList() {
        return this.promotionList;
    }

    public void setPromotionList(PromotionList promotionList) {
        this.promotionList = promotionList;
    }

    public ShipmentItem promotionAdjustmentList(PromotionList promotionAdjustmentList) {
        this.promotionAdjustmentList = promotionAdjustmentList;
        return this;
    }

    @Schema(description="")
    public PromotionList getPromotionAdjustmentList() {
        return this.promotionAdjustmentList;
    }

    public void setPromotionAdjustmentList(PromotionList promotionAdjustmentList) {
        this.promotionAdjustmentList = promotionAdjustmentList;
    }

    public ShipmentItem costOfPointsGranted(Currency costOfPointsGranted) {
        this.costOfPointsGranted = costOfPointsGranted;
        return this;
    }

    @Schema(description="")
    public Currency getCostOfPointsGranted() {
        return this.costOfPointsGranted;
    }

    public void setCostOfPointsGranted(Currency costOfPointsGranted) {
        this.costOfPointsGranted = costOfPointsGranted;
    }

    public ShipmentItem costOfPointsReturned(Currency costOfPointsReturned) {
        this.costOfPointsReturned = costOfPointsReturned;
        return this;
    }

    @Schema(description="")
    public Currency getCostOfPointsReturned() {
        return this.costOfPointsReturned;
    }

    public void setCostOfPointsReturned(Currency costOfPointsReturned) {
        this.costOfPointsReturned = costOfPointsReturned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentItem shipmentItem = (ShipmentItem)o;
        return Objects.equals(this.sellerSKU, shipmentItem.sellerSKU) && Objects.equals(this.orderItemId, shipmentItem.orderItemId) && Objects.equals(this.orderAdjustmentItemId, shipmentItem.orderAdjustmentItemId) && Objects.equals(this.quantityShipped, shipmentItem.quantityShipped) && Objects.equals(this.itemChargeList, shipmentItem.itemChargeList) && Objects.equals(this.itemChargeAdjustmentList, shipmentItem.itemChargeAdjustmentList) && Objects.equals(this.itemFeeList, shipmentItem.itemFeeList) && Objects.equals(this.itemFeeAdjustmentList, shipmentItem.itemFeeAdjustmentList) && Objects.equals(this.itemTaxWithheldList, shipmentItem.itemTaxWithheldList) && Objects.equals(this.promotionList, shipmentItem.promotionList) && Objects.equals(this.promotionAdjustmentList, shipmentItem.promotionAdjustmentList) && Objects.equals(this.costOfPointsGranted, shipmentItem.costOfPointsGranted) && Objects.equals(this.costOfPointsReturned, shipmentItem.costOfPointsReturned);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSKU, this.orderItemId, this.orderAdjustmentItemId, this.quantityShipped, this.itemChargeList, this.itemChargeAdjustmentList, this.itemFeeList, this.itemFeeAdjustmentList, this.itemTaxWithheldList, this.promotionList, this.promotionAdjustmentList, this.costOfPointsGranted, this.costOfPointsReturned);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentItem {\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    orderAdjustmentItemId: ").append(this.toIndentedString(this.orderAdjustmentItemId)).append("\n");
        sb.append("    quantityShipped: ").append(this.toIndentedString(this.quantityShipped)).append("\n");
        sb.append("    itemChargeList: ").append(this.toIndentedString(this.itemChargeList)).append("\n");
        sb.append("    itemChargeAdjustmentList: ").append(this.toIndentedString(this.itemChargeAdjustmentList)).append("\n");
        sb.append("    itemFeeList: ").append(this.toIndentedString(this.itemFeeList)).append("\n");
        sb.append("    itemFeeAdjustmentList: ").append(this.toIndentedString(this.itemFeeAdjustmentList)).append("\n");
        sb.append("    itemTaxWithheldList: ").append(this.toIndentedString(this.itemTaxWithheldList)).append("\n");
        sb.append("    promotionList: ").append(this.toIndentedString(this.promotionList)).append("\n");
        sb.append("    promotionAdjustmentList: ").append(this.toIndentedString(this.promotionAdjustmentList)).append("\n");
        sb.append("    costOfPointsGranted: ").append(this.toIndentedString(this.costOfPointsGranted)).append("\n");
        sb.append("    costOfPointsReturned: ").append(this.toIndentedString(this.costOfPointsReturned)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

