/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.ChargeComponentList;
import software.amazon.spapi.models.finances.v0.DirectPaymentList;
import software.amazon.spapi.models.finances.v0.FeeComponentList;
import software.amazon.spapi.models.finances.v0.ShipmentItemList;

@Schema(description="A shipment, refund, guarantee claim, or chargeback.")
public class ShipmentEvent {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="MarketplaceName")
    private String marketplaceName = null;
    @SerializedName(value="StoreName")
    private String storeName = null;
    @SerializedName(value="OrderChargeList")
    private ChargeComponentList orderChargeList = null;
    @SerializedName(value="OrderChargeAdjustmentList")
    private ChargeComponentList orderChargeAdjustmentList = null;
    @SerializedName(value="ShipmentFeeList")
    private FeeComponentList shipmentFeeList = null;
    @SerializedName(value="ShipmentFeeAdjustmentList")
    private FeeComponentList shipmentFeeAdjustmentList = null;
    @SerializedName(value="OrderFeeList")
    private FeeComponentList orderFeeList = null;
    @SerializedName(value="OrderFeeAdjustmentList")
    private FeeComponentList orderFeeAdjustmentList = null;
    @SerializedName(value="DirectPaymentList")
    private DirectPaymentList directPaymentList = null;
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="ShipmentItemList")
    private ShipmentItemList shipmentItemList = null;
    @SerializedName(value="ShipmentItemAdjustmentList")
    private ShipmentItemList shipmentItemAdjustmentList = null;

    public ShipmentEvent amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @Schema(description="An Amazon-defined identifier for an order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public ShipmentEvent sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @Schema(description="A seller-defined identifier for an order.")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public ShipmentEvent marketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
        return this;
    }

    @Schema(description="The name of the marketplace where the event occurred.")
    public String getMarketplaceName() {
        return this.marketplaceName;
    }

    public void setMarketplaceName(String marketplaceName) {
        this.marketplaceName = marketplaceName;
    }

    public ShipmentEvent storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    @Schema(description="The name of the store where the event occurred.")
    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public ShipmentEvent orderChargeList(ChargeComponentList orderChargeList) {
        this.orderChargeList = orderChargeList;
        return this;
    }

    @Schema(description="")
    public ChargeComponentList getOrderChargeList() {
        return this.orderChargeList;
    }

    public void setOrderChargeList(ChargeComponentList orderChargeList) {
        this.orderChargeList = orderChargeList;
    }

    public ShipmentEvent orderChargeAdjustmentList(ChargeComponentList orderChargeAdjustmentList) {
        this.orderChargeAdjustmentList = orderChargeAdjustmentList;
        return this;
    }

    @Schema(description="")
    public ChargeComponentList getOrderChargeAdjustmentList() {
        return this.orderChargeAdjustmentList;
    }

    public void setOrderChargeAdjustmentList(ChargeComponentList orderChargeAdjustmentList) {
        this.orderChargeAdjustmentList = orderChargeAdjustmentList;
    }

    public ShipmentEvent shipmentFeeList(FeeComponentList shipmentFeeList) {
        this.shipmentFeeList = shipmentFeeList;
        return this;
    }

    @Schema(description="")
    public FeeComponentList getShipmentFeeList() {
        return this.shipmentFeeList;
    }

    public void setShipmentFeeList(FeeComponentList shipmentFeeList) {
        this.shipmentFeeList = shipmentFeeList;
    }

    public ShipmentEvent shipmentFeeAdjustmentList(FeeComponentList shipmentFeeAdjustmentList) {
        this.shipmentFeeAdjustmentList = shipmentFeeAdjustmentList;
        return this;
    }

    @Schema(description="")
    public FeeComponentList getShipmentFeeAdjustmentList() {
        return this.shipmentFeeAdjustmentList;
    }

    public void setShipmentFeeAdjustmentList(FeeComponentList shipmentFeeAdjustmentList) {
        this.shipmentFeeAdjustmentList = shipmentFeeAdjustmentList;
    }

    public ShipmentEvent orderFeeList(FeeComponentList orderFeeList) {
        this.orderFeeList = orderFeeList;
        return this;
    }

    @Schema(description="")
    public FeeComponentList getOrderFeeList() {
        return this.orderFeeList;
    }

    public void setOrderFeeList(FeeComponentList orderFeeList) {
        this.orderFeeList = orderFeeList;
    }

    public ShipmentEvent orderFeeAdjustmentList(FeeComponentList orderFeeAdjustmentList) {
        this.orderFeeAdjustmentList = orderFeeAdjustmentList;
        return this;
    }

    @Schema(description="")
    public FeeComponentList getOrderFeeAdjustmentList() {
        return this.orderFeeAdjustmentList;
    }

    public void setOrderFeeAdjustmentList(FeeComponentList orderFeeAdjustmentList) {
        this.orderFeeAdjustmentList = orderFeeAdjustmentList;
    }

    public ShipmentEvent directPaymentList(DirectPaymentList directPaymentList) {
        this.directPaymentList = directPaymentList;
        return this;
    }

    @Schema(description="")
    public DirectPaymentList getDirectPaymentList() {
        return this.directPaymentList;
    }

    public void setDirectPaymentList(DirectPaymentList directPaymentList) {
        this.directPaymentList = directPaymentList;
    }

    public ShipmentEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public ShipmentEvent shipmentItemList(ShipmentItemList shipmentItemList) {
        this.shipmentItemList = shipmentItemList;
        return this;
    }

    @Schema(description="")
    public ShipmentItemList getShipmentItemList() {
        return this.shipmentItemList;
    }

    public void setShipmentItemList(ShipmentItemList shipmentItemList) {
        this.shipmentItemList = shipmentItemList;
    }

    public ShipmentEvent shipmentItemAdjustmentList(ShipmentItemList shipmentItemAdjustmentList) {
        this.shipmentItemAdjustmentList = shipmentItemAdjustmentList;
        return this;
    }

    @Schema(description="")
    public ShipmentItemList getShipmentItemAdjustmentList() {
        return this.shipmentItemAdjustmentList;
    }

    public void setShipmentItemAdjustmentList(ShipmentItemList shipmentItemAdjustmentList) {
        this.shipmentItemAdjustmentList = shipmentItemAdjustmentList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentEvent shipmentEvent = (ShipmentEvent)o;
        return Objects.equals(this.amazonOrderId, shipmentEvent.amazonOrderId) && Objects.equals(this.sellerOrderId, shipmentEvent.sellerOrderId) && Objects.equals(this.marketplaceName, shipmentEvent.marketplaceName) && Objects.equals(this.storeName, shipmentEvent.storeName) && Objects.equals(this.orderChargeList, shipmentEvent.orderChargeList) && Objects.equals(this.orderChargeAdjustmentList, shipmentEvent.orderChargeAdjustmentList) && Objects.equals(this.shipmentFeeList, shipmentEvent.shipmentFeeList) && Objects.equals(this.shipmentFeeAdjustmentList, shipmentEvent.shipmentFeeAdjustmentList) && Objects.equals(this.orderFeeList, shipmentEvent.orderFeeList) && Objects.equals(this.orderFeeAdjustmentList, shipmentEvent.orderFeeAdjustmentList) && Objects.equals(this.directPaymentList, shipmentEvent.directPaymentList) && Objects.equals(this.postedDate, shipmentEvent.postedDate) && Objects.equals(this.shipmentItemList, shipmentEvent.shipmentItemList) && Objects.equals(this.shipmentItemAdjustmentList, shipmentEvent.shipmentItemAdjustmentList);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.sellerOrderId, this.marketplaceName, this.storeName, this.orderChargeList, this.orderChargeAdjustmentList, this.shipmentFeeList, this.shipmentFeeAdjustmentList, this.orderFeeList, this.orderFeeAdjustmentList, this.directPaymentList, this.postedDate, this.shipmentItemList, this.shipmentItemAdjustmentList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentEvent {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    marketplaceName: ").append(this.toIndentedString(this.marketplaceName)).append("\n");
        sb.append("    storeName: ").append(this.toIndentedString(this.storeName)).append("\n");
        sb.append("    orderChargeList: ").append(this.toIndentedString(this.orderChargeList)).append("\n");
        sb.append("    orderChargeAdjustmentList: ").append(this.toIndentedString(this.orderChargeAdjustmentList)).append("\n");
        sb.append("    shipmentFeeList: ").append(this.toIndentedString(this.shipmentFeeList)).append("\n");
        sb.append("    shipmentFeeAdjustmentList: ").append(this.toIndentedString(this.shipmentFeeAdjustmentList)).append("\n");
        sb.append("    orderFeeList: ").append(this.toIndentedString(this.orderFeeList)).append("\n");
        sb.append("    orderFeeAdjustmentList: ").append(this.toIndentedString(this.orderFeeAdjustmentList)).append("\n");
        sb.append("    directPaymentList: ").append(this.toIndentedString(this.directPaymentList)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    shipmentItemList: ").append(this.toIndentedString(this.shipmentItemList)).append("\n");
        sb.append("    shipmentItemAdjustmentList: ").append(this.toIndentedString(this.shipmentItemAdjustmentList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

