/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.RemovalShipmentItemAdjustment;

@Schema(description="A financial adjustment event for FBA liquidated inventory. A positive value indicates money owed to Amazon by the buyer (for example, when the charge was incorrectly calculated as less than it should be). A negative value indicates a full or partial refund owed to the buyer (for example, when the buyer receives damaged items or fewer items than ordered).")
public class RemovalShipmentAdjustmentEvent {
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="AdjustmentEventId")
    private String adjustmentEventId = null;
    @SerializedName(value="MerchantOrderId")
    private String merchantOrderId = null;
    @SerializedName(value="OrderId")
    private String orderId = null;
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="RemovalShipmentItemAdjustmentList")
    private List<RemovalShipmentItemAdjustment> removalShipmentItemAdjustmentList = null;

    public RemovalShipmentAdjustmentEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public RemovalShipmentAdjustmentEvent adjustmentEventId(String adjustmentEventId) {
        this.adjustmentEventId = adjustmentEventId;
        return this;
    }

    @Schema(description="The unique identifier for the adjustment event.")
    public String getAdjustmentEventId() {
        return this.adjustmentEventId;
    }

    public void setAdjustmentEventId(String adjustmentEventId) {
        this.adjustmentEventId = adjustmentEventId;
    }

    public RemovalShipmentAdjustmentEvent merchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
        return this;
    }

    @Schema(description="The merchant removal orderId.")
    public String getMerchantOrderId() {
        return this.merchantOrderId;
    }

    public void setMerchantOrderId(String merchantOrderId) {
        this.merchantOrderId = merchantOrderId;
    }

    public RemovalShipmentAdjustmentEvent orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @Schema(description="The orderId for shipping inventory.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public RemovalShipmentAdjustmentEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="The type of removal order.  Possible values:  * WHOLESALE_LIQUIDATION.")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public RemovalShipmentAdjustmentEvent removalShipmentItemAdjustmentList(List<RemovalShipmentItemAdjustment> removalShipmentItemAdjustmentList) {
        this.removalShipmentItemAdjustmentList = removalShipmentItemAdjustmentList;
        return this;
    }

    public RemovalShipmentAdjustmentEvent addRemovalShipmentItemAdjustmentListItem(RemovalShipmentItemAdjustment removalShipmentItemAdjustmentListItem) {
        if (this.removalShipmentItemAdjustmentList == null) {
            this.removalShipmentItemAdjustmentList = new ArrayList<RemovalShipmentItemAdjustment>();
        }
        this.removalShipmentItemAdjustmentList.add(removalShipmentItemAdjustmentListItem);
        return this;
    }

    @Schema(description="A comma-delimited list of Removal shipmentItemAdjustment details for FBA inventory.")
    public List<RemovalShipmentItemAdjustment> getRemovalShipmentItemAdjustmentList() {
        return this.removalShipmentItemAdjustmentList;
    }

    public void setRemovalShipmentItemAdjustmentList(List<RemovalShipmentItemAdjustment> removalShipmentItemAdjustmentList) {
        this.removalShipmentItemAdjustmentList = removalShipmentItemAdjustmentList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovalShipmentAdjustmentEvent removalShipmentAdjustmentEvent = (RemovalShipmentAdjustmentEvent)o;
        return Objects.equals(this.postedDate, removalShipmentAdjustmentEvent.postedDate) && Objects.equals(this.adjustmentEventId, removalShipmentAdjustmentEvent.adjustmentEventId) && Objects.equals(this.merchantOrderId, removalShipmentAdjustmentEvent.merchantOrderId) && Objects.equals(this.orderId, removalShipmentAdjustmentEvent.orderId) && Objects.equals(this.transactionType, removalShipmentAdjustmentEvent.transactionType) && Objects.equals(this.removalShipmentItemAdjustmentList, removalShipmentAdjustmentEvent.removalShipmentItemAdjustmentList);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.adjustmentEventId, this.merchantOrderId, this.orderId, this.transactionType, this.removalShipmentItemAdjustmentList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemovalShipmentAdjustmentEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    adjustmentEventId: ").append(this.toIndentedString(this.adjustmentEventId)).append("\n");
        sb.append("    merchantOrderId: ").append(this.toIndentedString(this.merchantOrderId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    removalShipmentItemAdjustmentList: ").append(this.toIndentedString(this.removalShipmentItemAdjustmentList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

