/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.finances.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.finances.v0.AdjustmentItemList;
import software.amazon.spapi.models.finances.v0.Currency;

@Schema(description="An adjustment to the seller's account.")
public class AdjustmentEvent {
    @SerializedName(value="AdjustmentType")
    private String adjustmentType = null;
    @SerializedName(value="PostedDate")
    private OffsetDateTime postedDate = null;
    @SerializedName(value="StoreName")
    private String storeName = null;
    @SerializedName(value="AdjustmentAmount")
    private Currency adjustmentAmount = null;
    @SerializedName(value="AdjustmentItemList")
    private AdjustmentItemList adjustmentItemList = null;

    public AdjustmentEvent adjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
        return this;
    }

    @Schema(description="The type of adjustment.  Possible values:  * FBAInventoryReimbursement - An FBA inventory reimbursement to a seller's account. This occurs if a seller's inventory is damaged.  * ReserveEvent - A reserve event that is generated at the time of a settlement period closing. This occurs when some money from a seller's account is held back.  * PostageBilling - The amount paid by a seller for shipping labels.  * PostageRefund - The reimbursement of shipping labels purchased for orders that were canceled or refunded.  * LostOrDamagedReimbursement - An Amazon Easy Ship reimbursement to a seller's account for a package that we lost or damaged.  * CanceledButPickedUpReimbursement - An Amazon Easy Ship reimbursement to a seller's account. This occurs when a package is picked up and the order is subsequently canceled. This value is used only in the India marketplace.  * ReimbursementClawback - An Amazon Easy Ship reimbursement clawback from a seller's account. This occurs when a prior reimbursement is reversed. This value is used only in the India marketplace.  * SellerRewards - An award credited to a seller's account for their participation in an offer in the Seller Rewards program. Applies only to the India marketplace.")
    public String getAdjustmentType() {
        return this.adjustmentType;
    }

    public void setAdjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public AdjustmentEvent postedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(OffsetDateTime postedDate) {
        this.postedDate = postedDate;
    }

    public AdjustmentEvent storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    @Schema(description="The name of the store where the event occurred.")
    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public AdjustmentEvent adjustmentAmount(Currency adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
        return this;
    }

    @Schema(description="")
    public Currency getAdjustmentAmount() {
        return this.adjustmentAmount;
    }

    public void setAdjustmentAmount(Currency adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public AdjustmentEvent adjustmentItemList(AdjustmentItemList adjustmentItemList) {
        this.adjustmentItemList = adjustmentItemList;
        return this;
    }

    @Schema(description="")
    public AdjustmentItemList getAdjustmentItemList() {
        return this.adjustmentItemList;
    }

    public void setAdjustmentItemList(AdjustmentItemList adjustmentItemList) {
        this.adjustmentItemList = adjustmentItemList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjustmentEvent adjustmentEvent = (AdjustmentEvent)o;
        return Objects.equals(this.adjustmentType, adjustmentEvent.adjustmentType) && Objects.equals(this.postedDate, adjustmentEvent.postedDate) && Objects.equals(this.storeName, adjustmentEvent.storeName) && Objects.equals(this.adjustmentAmount, adjustmentEvent.adjustmentAmount) && Objects.equals(this.adjustmentItemList, adjustmentEvent.adjustmentItemList);
    }

    public int hashCode() {
        return Objects.hash(this.adjustmentType, this.postedDate, this.storeName, this.adjustmentAmount, this.adjustmentItemList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdjustmentEvent {\n");
        sb.append("    adjustmentType: ").append(this.toIndentedString(this.adjustmentType)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    storeName: ").append(this.toIndentedString(this.storeName)).append("\n");
        sb.append("    adjustmentAmount: ").append(this.toIndentedString(this.adjustmentAmount)).append("\n");
        sb.append("    adjustmentItemList: ").append(this.toIndentedString(this.adjustmentItemList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

