/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fba.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The quantity of reserved inventory.")
public class ReservedQuantity {
    @SerializedName(value="totalReservedQuantity")
    private Integer totalReservedQuantity = null;
    @SerializedName(value="pendingCustomerOrderQuantity")
    private Integer pendingCustomerOrderQuantity = null;
    @SerializedName(value="pendingTransshipmentQuantity")
    private Integer pendingTransshipmentQuantity = null;
    @SerializedName(value="fcProcessingQuantity")
    private Integer fcProcessingQuantity = null;

    public ReservedQuantity totalReservedQuantity(Integer totalReservedQuantity) {
        this.totalReservedQuantity = totalReservedQuantity;
        return this;
    }

    @Schema(description="The total number of units in Amazon's fulfillment network that are currently being picked, packed, and shipped; or are sidelined for measurement, sampling, or other internal processes.")
    public Integer getTotalReservedQuantity() {
        return this.totalReservedQuantity;
    }

    public void setTotalReservedQuantity(Integer totalReservedQuantity) {
        this.totalReservedQuantity = totalReservedQuantity;
    }

    public ReservedQuantity pendingCustomerOrderQuantity(Integer pendingCustomerOrderQuantity) {
        this.pendingCustomerOrderQuantity = pendingCustomerOrderQuantity;
        return this;
    }

    @Schema(description="The number of units reserved for customer orders.")
    public Integer getPendingCustomerOrderQuantity() {
        return this.pendingCustomerOrderQuantity;
    }

    public void setPendingCustomerOrderQuantity(Integer pendingCustomerOrderQuantity) {
        this.pendingCustomerOrderQuantity = pendingCustomerOrderQuantity;
    }

    public ReservedQuantity pendingTransshipmentQuantity(Integer pendingTransshipmentQuantity) {
        this.pendingTransshipmentQuantity = pendingTransshipmentQuantity;
        return this;
    }

    @Schema(description="The number of units being transferred from one fulfillment center to another.")
    public Integer getPendingTransshipmentQuantity() {
        return this.pendingTransshipmentQuantity;
    }

    public void setPendingTransshipmentQuantity(Integer pendingTransshipmentQuantity) {
        this.pendingTransshipmentQuantity = pendingTransshipmentQuantity;
    }

    public ReservedQuantity fcProcessingQuantity(Integer fcProcessingQuantity) {
        this.fcProcessingQuantity = fcProcessingQuantity;
        return this;
    }

    @Schema(description="The number of units that have been sidelined at the fulfillment center for additional processing.")
    public Integer getFcProcessingQuantity() {
        return this.fcProcessingQuantity;
    }

    public void setFcProcessingQuantity(Integer fcProcessingQuantity) {
        this.fcProcessingQuantity = fcProcessingQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReservedQuantity reservedQuantity = (ReservedQuantity)o;
        return Objects.equals(this.totalReservedQuantity, reservedQuantity.totalReservedQuantity) && Objects.equals(this.pendingCustomerOrderQuantity, reservedQuantity.pendingCustomerOrderQuantity) && Objects.equals(this.pendingTransshipmentQuantity, reservedQuantity.pendingTransshipmentQuantity) && Objects.equals(this.fcProcessingQuantity, reservedQuantity.fcProcessingQuantity);
    }

    public int hashCode() {
        return Objects.hash(this.totalReservedQuantity, this.pendingCustomerOrderQuantity, this.pendingTransshipmentQuantity, this.fcProcessingQuantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReservedQuantity {\n");
        sb.append("    totalReservedQuantity: ").append(this.toIndentedString(this.totalReservedQuantity)).append("\n");
        sb.append("    pendingCustomerOrderQuantity: ").append(this.toIndentedString(this.pendingCustomerOrderQuantity)).append("\n");
        sb.append("    pendingTransshipmentQuantity: ").append(this.toIndentedString(this.pendingTransshipmentQuantity)).append("\n");
        sb.append("    fcProcessingQuantity: ").append(this.toIndentedString(this.fcProcessingQuantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

