/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fba.inventory.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The process of returning the results to a request in batches of a defined size called pages. This is done to exercise some control over result size and overall throughput. It's a form of traffic management.")
public class Pagination {
    @SerializedName(value="nextToken")
    private String nextToken = null;

    public Pagination nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="A generated string used to retrieve the next page of the result. If nextToken is returned, pass the value of nextToken to the next request. If nextToken is not returned, there are no more items to return.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pagination = (Pagination)o;
        return Objects.equals(this.nextToken, pagination.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.nextToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pagination {\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

