/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.datakiosk.v2023_11_15;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="When a query produces results that are not included in the data document, pagination occurs. This means the results are divided into pages. To retrieve the next page, you must pass a `CreateQuerySpecification` object with `paginationToken` set to this object's `nextToken` and with `query` set to this object's `query` in the subsequent `createQuery` request. When there are no more pages to fetch, the `nextToken` field will be absent.")
public class QueryPagination {
    @SerializedName(value="nextToken")
    private String nextToken = null;

    public QueryPagination nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="A token that can be used to fetch the next page of results.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryPagination queryPagination = (QueryPagination)o;
        return Objects.equals(this.nextToken, queryPagination.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.nextToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryPagination {\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

