/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.datakiosk.v2023_11_15;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Information required to create the query.")
public class CreateQuerySpecification {
    @SerializedName(value="query")
    private String query = null;
    @SerializedName(value="paginationToken")
    private String paginationToken = null;

    public CreateQuerySpecification query(String query) {
        this.query = query;
        return this;
    }

    @Schema(required=true, description="The GraphQL query to submit. A query must be at most 8000 characters after unnecessary whitespace is removed.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public CreateQuerySpecification paginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
        return this;
    }

    @Schema(description="A token to fetch a certain page of query results when there are multiple pages of query results available. The value of this token must be fetched from the `pagination.nextToken` field of the `Query` object, and the `query` field for this object must also be set to the `query` field of the same `Query` object. A `Query` object can be retrieved from either the `getQueries` or `getQuery` operation. In the absence of this token value, the first page of query results will be requested.")
    public String getPaginationToken() {
        return this.paginationToken;
    }

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateQuerySpecification createQuerySpecification = (CreateQuerySpecification)o;
        return Objects.equals(this.query, createQuerySpecification.query) && Objects.equals(this.paginationToken, createQuerySpecification.paginationToken);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.paginationToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateQuerySpecification {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    paginationToken: ").append(this.toIndentedString(this.paginationToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

