/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewTrend;

@Schema(description="The 10 most positive and most negative review topics for all items in a browse node.")
public class ItemReviewTrends {
    @SerializedName(value="positiveTopics")
    private List<ItemReviewTrend> positiveTopics = null;
    @SerializedName(value="negativeTopics")
    private List<ItemReviewTrend> negativeTopics = null;

    public ItemReviewTrends positiveTopics(List<ItemReviewTrend> positiveTopics) {
        this.positiveTopics = positiveTopics;
        return this;
    }

    public ItemReviewTrends addPositiveTopicsItem(ItemReviewTrend positiveTopicsItem) {
        if (this.positiveTopics == null) {
            this.positiveTopics = new ArrayList<ItemReviewTrend>();
        }
        this.positiveTopics.add(positiveTopicsItem);
        return this;
    }

    @Schema(description="A list of the most positive review topics. The percentage of reviews that contain the topic determines the topic's placement in the list. This value is `null` if there are not enough positive reviews for the specified ASIN.  **Max length:** 10")
    public List<ItemReviewTrend> getPositiveTopics() {
        return this.positiveTopics;
    }

    public void setPositiveTopics(List<ItemReviewTrend> positiveTopics) {
        this.positiveTopics = positiveTopics;
    }

    public ItemReviewTrends negativeTopics(List<ItemReviewTrend> negativeTopics) {
        this.negativeTopics = negativeTopics;
        return this;
    }

    public ItemReviewTrends addNegativeTopicsItem(ItemReviewTrend negativeTopicsItem) {
        if (this.negativeTopics == null) {
            this.negativeTopics = new ArrayList<ItemReviewTrend>();
        }
        this.negativeTopics.add(negativeTopicsItem);
        return this;
    }

    @Schema(description="A list of the most negative review topics. The percentage of reviews that contain the topic determines the topic's placement in the list. This value is `null` if there are not enough negative reviews for the specified ASIN.  **Max length:** 10")
    public List<ItemReviewTrend> getNegativeTopics() {
        return this.negativeTopics;
    }

    public void setNegativeTopics(List<ItemReviewTrend> negativeTopics) {
        this.negativeTopics = negativeTopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemReviewTrends itemReviewTrends = (ItemReviewTrends)o;
        return Objects.equals(this.positiveTopics, itemReviewTrends.positiveTopics) && Objects.equals(this.negativeTopics, itemReviewTrends.negativeTopics);
    }

    public int hashCode() {
        return Objects.hash(this.positiveTopics, this.negativeTopics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemReviewTrends {\n");
        sb.append("    positiveTopics: ").append(this.toIndentedString(this.positiveTopics)).append("\n");
        sb.append("    negativeTopics: ").append(this.toIndentedString(this.negativeTopics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

