/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.ItemReviewTopic;

@Schema(description="The top 10 positive and negative item review topics.")
public class ItemReviewTopics {
    @SerializedName(value="positiveTopics")
    private List<ItemReviewTopic> positiveTopics = null;
    @SerializedName(value="negativeTopics")
    private List<ItemReviewTopic> negativeTopics = null;

    public ItemReviewTopics positiveTopics(List<ItemReviewTopic> positiveTopics) {
        this.positiveTopics = positiveTopics;
        return this;
    }

    public ItemReviewTopics addPositiveTopicsItem(ItemReviewTopic positiveTopicsItem) {
        if (this.positiveTopics == null) {
            this.positiveTopics = new ArrayList<ItemReviewTopic>();
        }
        this.positiveTopics.add(positiveTopicsItem);
        return this;
    }

    @Schema(description="A list of the most positive review topics. When the `sortBy` query parameter is set to `MENTIONS`, the number of reviews that mention the topic determines the topic's placement in the list. When `sortBy` is set to `STAR_RATING_IMPACT`, the effect that the topic has on the star rating of the item determines placement in the list. This value is `null` if there are not enough positive reviews for the specified ASIN.  **Max length:** 10")
    public List<ItemReviewTopic> getPositiveTopics() {
        return this.positiveTopics;
    }

    public void setPositiveTopics(List<ItemReviewTopic> positiveTopics) {
        this.positiveTopics = positiveTopics;
    }

    public ItemReviewTopics negativeTopics(List<ItemReviewTopic> negativeTopics) {
        this.negativeTopics = negativeTopics;
        return this;
    }

    public ItemReviewTopics addNegativeTopicsItem(ItemReviewTopic negativeTopicsItem) {
        if (this.negativeTopics == null) {
            this.negativeTopics = new ArrayList<ItemReviewTopic>();
        }
        this.negativeTopics.add(negativeTopicsItem);
        return this;
    }

    @Schema(description="A list of the most negative review topics. When the `sortBy` query parameter is set to `MENTIONS`, the number of reviews that mention the topic determines the topic's placement in the list. When `sortBy` is set to `STAR_RATING_IMPACT`, the effect that the topic has on the star rating of the item determines placement in the list. This value is `null` if there are not enough negative reviews for the specified ASIN.  **Max length:** 10")
    public List<ItemReviewTopic> getNegativeTopics() {
        return this.negativeTopics;
    }

    public void setNegativeTopics(List<ItemReviewTopic> negativeTopics) {
        this.negativeTopics = negativeTopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemReviewTopics itemReviewTopics = (ItemReviewTopics)o;
        return Objects.equals(this.positiveTopics, itemReviewTopics.positiveTopics) && Objects.equals(this.negativeTopics, itemReviewTopics.negativeTopics);
    }

    public int hashCode() {
        return Objects.hash(this.positiveTopics, this.negativeTopics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemReviewTopics {\n");
        sb.append("    positiveTopics: ").append(this.toIndentedString(this.positiveTopics)).append("\n");
        sb.append("    negativeTopics: ").append(this.toIndentedString(this.negativeTopics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

