/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The item review topic metrics.")
public class ItemReviewTopicMetrics {
    @SerializedName(value="numberOfMentions")
    private Integer numberOfMentions = null;
    @SerializedName(value="occurrencePercentage")
    private Float occurrencePercentage = null;
    @SerializedName(value="starRatingImpact")
    private Float starRatingImpact = null;

    public ItemReviewTopicMetrics numberOfMentions(Integer numberOfMentions) {
        this.numberOfMentions = numberOfMentions;
        return this;
    }

    @Schema(description="The number of times that reviews mention the topic. This value is `null` if reviews do not mention the topic frequently enough.")
    public Integer getNumberOfMentions() {
        return this.numberOfMentions;
    }

    public void setNumberOfMentions(Integer numberOfMentions) {
        this.numberOfMentions = numberOfMentions;
    }

    public ItemReviewTopicMetrics occurrencePercentage(Float occurrencePercentage) {
        this.occurrencePercentage = occurrencePercentage;
        return this;
    }

    @Schema(description="The percentage of customer reviews that mention the topic. This value is `null` if reviews do not mention the topic frequently enough.")
    public Float getOccurrencePercentage() {
        return this.occurrencePercentage;
    }

    public void setOccurrencePercentage(Float occurrencePercentage) {
        this.occurrencePercentage = occurrencePercentage;
    }

    public ItemReviewTopicMetrics starRatingImpact(Float starRatingImpact) {
        this.starRatingImpact = starRatingImpact;
        return this;
    }

    @Schema(description="The effect of the topic on the star rating of the ASIN. This value can be positive or negative. This value is `null` if the topic does't affect the star rating of the ASIN.")
    public Float getStarRatingImpact() {
        return this.starRatingImpact;
    }

    public void setStarRatingImpact(Float starRatingImpact) {
        this.starRatingImpact = starRatingImpact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemReviewTopicMetrics itemReviewTopicMetrics = (ItemReviewTopicMetrics)o;
        return Objects.equals(this.numberOfMentions, itemReviewTopicMetrics.numberOfMentions) && Objects.equals(this.occurrencePercentage, itemReviewTopicMetrics.occurrencePercentage) && Objects.equals(this.starRatingImpact, itemReviewTopicMetrics.starRatingImpact);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfMentions, this.occurrencePercentage, this.starRatingImpact);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemReviewTopicMetrics {\n");
        sb.append("    numberOfMentions: ").append(this.toIndentedString(this.numberOfMentions)).append("\n");
        sb.append("    occurrencePercentage: ").append(this.toIndentedString(this.occurrencePercentage)).append("\n");
        sb.append("    starRatingImpact: ").append(this.toIndentedString(this.starRatingImpact)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

