/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReviewSubtopicMetrics;

@Schema(description="The browse node review subtopic.")
public class BrowseNodeSubtopic {
    @SerializedName(value="subtopic")
    private String subtopic = null;
    @SerializedName(value="metrics")
    private BrowseNodeReviewSubtopicMetrics metrics = null;
    @SerializedName(value="reviewSnippets")
    private List<String> reviewSnippets = null;

    public BrowseNodeSubtopic subtopic(String subtopic) {
        this.subtopic = subtopic;
        return this;
    }

    @Schema(required=true, description="The name of the browse node review subtopic.")
    public String getSubtopic() {
        return this.subtopic;
    }

    public void setSubtopic(String subtopic) {
        this.subtopic = subtopic;
    }

    public BrowseNodeSubtopic metrics(BrowseNodeReviewSubtopicMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(required=true, description="")
    public BrowseNodeReviewSubtopicMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(BrowseNodeReviewSubtopicMetrics metrics) {
        this.metrics = metrics;
    }

    public BrowseNodeSubtopic reviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
        return this;
    }

    public BrowseNodeSubtopic addReviewSnippetsItem(String reviewSnippetsItem) {
        if (this.reviewSnippets == null) {
            this.reviewSnippets = new ArrayList<String>();
        }
        this.reviewSnippets.add(reviewSnippetsItem);
        return this;
    }

    @Schema(description="A list of up to three snippets from reviews that contain the topic. This value is `null` if there aren't enough review snippets for the subtopic.")
    public List<String> getReviewSnippets() {
        return this.reviewSnippets;
    }

    public void setReviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowseNodeSubtopic browseNodeSubtopic = (BrowseNodeSubtopic)o;
        return Objects.equals(this.subtopic, browseNodeSubtopic.subtopic) && Objects.equals(this.metrics, browseNodeSubtopic.metrics) && Objects.equals(this.reviewSnippets, browseNodeSubtopic.reviewSnippets);
    }

    public int hashCode() {
        return Objects.hash(this.subtopic, this.metrics, this.reviewSnippets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrowseNodeSubtopic {\n");
        sb.append("    subtopic: ").append(this.toIndentedString(this.subtopic)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    reviewSnippets: ").append(this.toIndentedString(this.reviewSnippets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

