/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.customerfeedback.v2024_06_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeReviewTopicMetrics;
import software.amazon.spapi.models.customerfeedback.v2024_06_01.BrowseNodeSubtopic;

@Schema(description="The browse node review topic.")
public class BrowseNodeReviewTopic {
    @SerializedName(value="topic")
    private String topic = null;
    @SerializedName(value="browseNodeMetrics")
    private BrowseNodeReviewTopicMetrics browseNodeMetrics = null;
    @SerializedName(value="reviewSnippets")
    private List<String> reviewSnippets = null;
    @SerializedName(value="subtopics")
    private List<BrowseNodeSubtopic> subtopics = null;

    public BrowseNodeReviewTopic topic(String topic) {
        this.topic = topic;
        return this;
    }

    @Schema(required=true, description="The name browse node review topic.")
    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public BrowseNodeReviewTopic browseNodeMetrics(BrowseNodeReviewTopicMetrics browseNodeMetrics) {
        this.browseNodeMetrics = browseNodeMetrics;
        return this;
    }

    @Schema(required=true, description="")
    public BrowseNodeReviewTopicMetrics getBrowseNodeMetrics() {
        return this.browseNodeMetrics;
    }

    public void setBrowseNodeMetrics(BrowseNodeReviewTopicMetrics browseNodeMetrics) {
        this.browseNodeMetrics = browseNodeMetrics;
    }

    public BrowseNodeReviewTopic reviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
        return this;
    }

    public BrowseNodeReviewTopic addReviewSnippetsItem(String reviewSnippetsItem) {
        if (this.reviewSnippets == null) {
            this.reviewSnippets = new ArrayList<String>();
        }
        this.reviewSnippets.add(reviewSnippetsItem);
        return this;
    }

    @Schema(description="A list of up to three snippets from reviews that contain the topic. This value is `null` if there aren't enough review snippets for the topic.")
    public List<String> getReviewSnippets() {
        return this.reviewSnippets;
    }

    public void setReviewSnippets(List<String> reviewSnippets) {
        this.reviewSnippets = reviewSnippets;
    }

    public BrowseNodeReviewTopic subtopics(List<BrowseNodeSubtopic> subtopics) {
        this.subtopics = subtopics;
        return this;
    }

    public BrowseNodeReviewTopic addSubtopicsItem(BrowseNodeSubtopic subtopicsItem) {
        if (this.subtopics == null) {
            this.subtopics = new ArrayList<BrowseNodeSubtopic>();
        }
        this.subtopics.add(subtopicsItem);
        return this;
    }

    @Schema(description="A list of the five subtopics that occur most frequently. This value is `null` if there are no subtopics.")
    public List<BrowseNodeSubtopic> getSubtopics() {
        return this.subtopics;
    }

    public void setSubtopics(List<BrowseNodeSubtopic> subtopics) {
        this.subtopics = subtopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrowseNodeReviewTopic browseNodeReviewTopic = (BrowseNodeReviewTopic)o;
        return Objects.equals(this.topic, browseNodeReviewTopic.topic) && Objects.equals(this.browseNodeMetrics, browseNodeReviewTopic.browseNodeMetrics) && Objects.equals(this.reviewSnippets, browseNodeReviewTopic.reviewSnippets) && Objects.equals(this.subtopics, browseNodeReviewTopic.subtopics);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.browseNodeMetrics, this.reviewSnippets, this.subtopics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BrowseNodeReviewTopic {\n");
        sb.append("    topic: ").append(this.toIndentedString(this.topic)).append("\n");
        sb.append("    browseNodeMetrics: ").append(this.toIndentedString(this.browseNodeMetrics)).append("\n");
        sb.append("    reviewSnippets: ").append(this.toIndentedString(this.reviewSnippets)).append("\n");
        sb.append("    subtopics: ").append(this.toIndentedString(this.subtopics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

