/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.catalogitems.v2022_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.catalogitems.v2022_04_01.ItemBrowseClassification;

@Schema(description="Classifications (browse nodes) that are associated with the item in the Amazon catalog for the indicated `marketplaceId`.")
public class ItemBrowseClassificationsByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="classifications")
    private List<ItemBrowseClassification> classifications = null;

    public ItemBrowseClassificationsByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="Amazon marketplace identifier. To find the ID for your marketplace, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids).")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemBrowseClassificationsByMarketplace classifications(List<ItemBrowseClassification> classifications) {
        this.classifications = classifications;
        return this;
    }

    public ItemBrowseClassificationsByMarketplace addClassificationsItem(ItemBrowseClassification classificationsItem) {
        if (this.classifications == null) {
            this.classifications = new ArrayList<ItemBrowseClassification>();
        }
        this.classifications.add(classificationsItem);
        return this;
    }

    @Schema(description="Classifications (browse nodes) that are associated with the item in the Amazon catalog.")
    public List<ItemBrowseClassification> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<ItemBrowseClassification> classifications) {
        this.classifications = classifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemBrowseClassificationsByMarketplace itemBrowseClassificationsByMarketplace = (ItemBrowseClassificationsByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemBrowseClassificationsByMarketplace.marketplaceId) && Objects.equals(this.classifications, itemBrowseClassificationsByMarketplace.classifications);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.classifications);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemBrowseClassificationsByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    classifications: ").append(this.toIndentedString(this.classifications)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

