/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.awd.v2024_05_09.DistributionPackageQuantity;

@Schema(description="Represents the packages to inbound.")
public class InboundPackages {
    @SerializedName(value="packagesToInbound")
    private List<DistributionPackageQuantity> packagesToInbound = new ArrayList<DistributionPackageQuantity>();

    public InboundPackages packagesToInbound(List<DistributionPackageQuantity> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
        return this;
    }

    public InboundPackages addPackagesToInboundItem(DistributionPackageQuantity packagesToInboundItem) {
        this.packagesToInbound.add(packagesToInboundItem);
        return this;
    }

    @Schema(example="[{\"count\":1,\"distributionPackage\":{\"contents\":{\"products\":[{\"quantity\":1,\"sku\":\"testPen\"}]},\"measurements\":{\"dimensions\":{\"height\":1,\"length\":1,\"unitOfMeasurement\":\"INCHES\",\"width\":1},\"volume\":{\"unitOfMeasurement\":\"CUIN\",\"volume\":1},\"weight\":{\"unitOfMeasurement\":\"POUNDS\",\"weight\":1}},\"type\":\"CASE\"}}]", required=true, description="List of packages to be inbounded.")
    public List<DistributionPackageQuantity> getPackagesToInbound() {
        return this.packagesToInbound;
    }

    public void setPackagesToInbound(List<DistributionPackageQuantity> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundPackages inboundPackages = (InboundPackages)o;
        return Objects.equals(this.packagesToInbound, inboundPackages.packagesToInbound);
    }

    public int hashCode() {
        return Objects.hash(this.packagesToInbound);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundPackages {\n");
        sb.append("    packagesToInbound: ").append(this.toIndentedString(this.packagesToInbound)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

