/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.awd.v2024_05_09;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.awd.v2024_05_09.InboundEligibilityStatus;
import software.amazon.spapi.models.awd.v2024_05_09.OrderIneligibilityReason;
import software.amazon.spapi.models.awd.v2024_05_09.SkuEligibility;

@Schema(description="Represents the eligibility status of the inbound packages.")
public class InboundEligibility {
    @SerializedName(value="ineligibilityReasons")
    private List<OrderIneligibilityReason> ineligibilityReasons = null;
    @SerializedName(value="packagesToInbound")
    private List<SkuEligibility> packagesToInbound = new ArrayList<SkuEligibility>();
    @SerializedName(value="previewedAt")
    private OffsetDateTime previewedAt = null;
    @SerializedName(value="status")
    private InboundEligibilityStatus status = null;

    public InboundEligibility ineligibilityReasons(List<OrderIneligibilityReason> ineligibilityReasons) {
        this.ineligibilityReasons = ineligibilityReasons;
        return this;
    }

    public InboundEligibility addIneligibilityReasonsItem(OrderIneligibilityReason ineligibilityReasonsItem) {
        if (this.ineligibilityReasons == null) {
            this.ineligibilityReasons = new ArrayList<OrderIneligibilityReason>();
        }
        this.ineligibilityReasons.add(ineligibilityReasonsItem);
        return this;
    }

    @Schema(description="If there are order level eligibility issues, then this list will contain those error codes and descriptions.")
    public List<OrderIneligibilityReason> getIneligibilityReasons() {
        return this.ineligibilityReasons;
    }

    public void setIneligibilityReasons(List<OrderIneligibilityReason> ineligibilityReasons) {
        this.ineligibilityReasons = ineligibilityReasons;
    }

    public InboundEligibility packagesToInbound(List<SkuEligibility> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
        return this;
    }

    public InboundEligibility addPackagesToInboundItem(SkuEligibility packagesToInboundItem) {
        this.packagesToInbound.add(packagesToInboundItem);
        return this;
    }

    @Schema(required=true, description="Details on SKU eligibility for each inbound package.")
    public List<SkuEligibility> getPackagesToInbound() {
        return this.packagesToInbound;
    }

    public void setPackagesToInbound(List<SkuEligibility> packagesToInbound) {
        this.packagesToInbound = packagesToInbound;
    }

    public InboundEligibility previewedAt(OffsetDateTime previewedAt) {
        this.previewedAt = previewedAt;
        return this;
    }

    @Schema(required=true, description="Timestamp when the eligibility check is performed.")
    public OffsetDateTime getPreviewedAt() {
        return this.previewedAt;
    }

    public void setPreviewedAt(OffsetDateTime previewedAt) {
        this.previewedAt = previewedAt;
    }

    public InboundEligibility status(InboundEligibilityStatus status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="")
    public InboundEligibilityStatus getStatus() {
        return this.status;
    }

    public void setStatus(InboundEligibilityStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundEligibility inboundEligibility = (InboundEligibility)o;
        return Objects.equals(this.ineligibilityReasons, inboundEligibility.ineligibilityReasons) && Objects.equals(this.packagesToInbound, inboundEligibility.packagesToInbound) && Objects.equals(this.previewedAt, inboundEligibility.previewedAt) && Objects.equals((Object)this.status, (Object)inboundEligibility.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ineligibilityReasons, this.packagesToInbound, this.previewedAt, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundEligibility {\n");
        sb.append("    ineligibilityReasons: ").append(this.toIndentedString(this.ineligibilityReasons)).append("\n");
        sb.append("    packagesToInbound: ").append(this.toIndentedString(this.packagesToInbound)).append("\n");
        sb.append("    previewedAt: ").append(this.toIndentedString(this.previewedAt)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

