/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.appintegrations.v2024_04_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.appintegrations.v2024_04_01.NotificationParameters;

@Schema(description="The request for the `createNotification` operation.")
public class CreateNotificationRequest {
    @SerializedName(value="templateId")
    private String templateId = null;
    @SerializedName(value="notificationParameters")
    private NotificationParameters notificationParameters = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;

    public CreateNotificationRequest templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @Schema(required=true, description="The unique identifier of the notification template you used to onboard your application.")
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public CreateNotificationRequest notificationParameters(NotificationParameters notificationParameters) {
        this.notificationParameters = notificationParameters;
        return this;
    }

    @Schema(required=true, description="")
    public NotificationParameters getNotificationParameters() {
        return this.notificationParameters;
    }

    public void setNotificationParameters(NotificationParameters notificationParameters) {
        this.notificationParameters = notificationParameters;
    }

    public CreateNotificationRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="An encrypted marketplace identifier for the posted notification.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNotificationRequest createNotificationRequest = (CreateNotificationRequest)o;
        return Objects.equals(this.templateId, createNotificationRequest.templateId) && Objects.equals(this.notificationParameters, createNotificationRequest.notificationParameters) && Objects.equals(this.marketplaceId, createNotificationRequest.marketplaceId);
    }

    public int hashCode() {
        return Objects.hash(this.templateId, this.notificationParameters, this.marketplaceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateNotificationRequest {\n");
        sb.append("    templateId: ").append(this.toIndentedString(this.templateId)).append("\n");
        sb.append("    notificationParameters: ").append(this.toIndentedString(this.notificationParameters)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

