/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.shipments.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.shipments.v1.GetShipmentDetailsResponse;
import software.amazon.spapi.models.vendor.shipments.v1.GetShipmentLabels;
import software.amazon.spapi.models.vendor.shipments.v1.SubmitShipmentConfirmationsRequest;
import software.amazon.spapi.models.vendor.shipments.v1.SubmitShipmentConfirmationsResponse;
import software.amazon.spapi.models.vendor.shipments.v1.SubmitShipments;

public class VendorShippingApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket getShipmentDetailsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-getShipmentDetails")).build();
    public final Bucket getShipmentLabelsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-getShipmentLabels")).build();
    public final Bucket submitShipmentConfirmationsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-submitShipmentConfirmations")).build();
    public final Bucket submitShipmentsBucket = Bucket.builder().addLimit(this.config.getLimit("VendorShippingApi-submitShipments")).build();

    public VendorShippingApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call getShipmentDetailsCall(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/shipping/v1/shipments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/shipping/v1/shipments" : "/vendor/shipping/v1/shipments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (createdAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdAfter", createdAfter));
        }
        if (createdBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("createdBefore", createdBefore));
        }
        if (shipmentConfirmedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipmentConfirmedBefore", shipmentConfirmedBefore));
        }
        if (shipmentConfirmedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipmentConfirmedAfter", shipmentConfirmedAfter));
        }
        if (packageLabelCreatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("packageLabelCreatedBefore", packageLabelCreatedBefore));
        }
        if (packageLabelCreatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("packageLabelCreatedAfter", packageLabelCreatedAfter));
        }
        if (shippedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shippedBefore", shippedBefore));
        }
        if (shippedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shippedAfter", shippedAfter));
        }
        if (estimatedDeliveryBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("estimatedDeliveryBefore", estimatedDeliveryBefore));
        }
        if (estimatedDeliveryAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("estimatedDeliveryAfter", estimatedDeliveryAfter));
        }
        if (shipmentDeliveryBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipmentDeliveryBefore", shipmentDeliveryBefore));
        }
        if (shipmentDeliveryAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("shipmentDeliveryAfter", shipmentDeliveryAfter));
        }
        if (requestedPickUpBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requestedPickUpBefore", requestedPickUpBefore));
        }
        if (requestedPickUpAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("requestedPickUpAfter", requestedPickUpAfter));
        }
        if (scheduledPickUpBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("scheduledPickUpBefore", scheduledPickUpBefore));
        }
        if (scheduledPickUpAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("scheduledPickUpAfter", scheduledPickUpAfter));
        }
        if (currentShipmentStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("currentShipmentStatus", currentShipmentStatus));
        }
        if (vendorShipmentIdentifier != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("vendorShipmentIdentifier", vendorShipmentIdentifier));
        }
        if (buyerReferenceNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("buyerReferenceNumber", buyerReferenceNumber));
        }
        if (buyerWarehouseCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("buyerWarehouseCode", buyerWarehouseCode));
        }
        if (sellerWarehouseCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerWarehouseCode", sellerWarehouseCode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentDetailsValidateBeforeCall(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getShipmentDetailsCall(limit, sortOrder, nextToken, createdAfter, createdBefore, shipmentConfirmedBefore, shipmentConfirmedAfter, packageLabelCreatedBefore, packageLabelCreatedAfter, shippedBefore, shippedAfter, estimatedDeliveryBefore, estimatedDeliveryAfter, shipmentDeliveryBefore, shipmentDeliveryAfter, requestedPickUpBefore, requestedPickUpAfter, scheduledPickUpBefore, scheduledPickUpAfter, currentShipmentStatus, vendorShipmentIdentifier, buyerReferenceNumber, buyerWarehouseCode, sellerWarehouseCode, progressRequestListener);
    }

    public GetShipmentDetailsResponse getShipmentDetails(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentDetailsResponse> resp = this.getShipmentDetailsWithHttpInfo(limit, sortOrder, nextToken, createdAfter, createdBefore, shipmentConfirmedBefore, shipmentConfirmedAfter, packageLabelCreatedBefore, packageLabelCreatedAfter, shippedBefore, shippedAfter, estimatedDeliveryBefore, estimatedDeliveryAfter, shipmentDeliveryBefore, shipmentDeliveryAfter, requestedPickUpBefore, requestedPickUpAfter, scheduledPickUpBefore, scheduledPickUpAfter, currentShipmentStatus, vendorShipmentIdentifier, buyerReferenceNumber, buyerWarehouseCode, sellerWarehouseCode, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentDetailsResponse getShipmentDetails(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode) throws ApiException, LWAException {
        ApiResponse<GetShipmentDetailsResponse> resp = this.getShipmentDetailsWithHttpInfo(limit, sortOrder, nextToken, createdAfter, createdBefore, shipmentConfirmedBefore, shipmentConfirmedAfter, packageLabelCreatedBefore, packageLabelCreatedAfter, shippedBefore, shippedAfter, estimatedDeliveryBefore, estimatedDeliveryAfter, shipmentDeliveryBefore, shipmentDeliveryAfter, requestedPickUpBefore, requestedPickUpAfter, scheduledPickUpBefore, scheduledPickUpAfter, currentShipmentStatus, vendorShipmentIdentifier, buyerReferenceNumber, buyerWarehouseCode, sellerWarehouseCode, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentDetailsResponse> getShipmentDetailsWithHttpInfo(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentDetailsValidateBeforeCall(limit, sortOrder, nextToken, createdAfter, createdBefore, shipmentConfirmedBefore, shipmentConfirmedAfter, packageLabelCreatedBefore, packageLabelCreatedAfter, shippedBefore, shippedAfter, estimatedDeliveryBefore, estimatedDeliveryAfter, shipmentDeliveryBefore, shipmentDeliveryAfter, requestedPickUpBefore, requestedPickUpAfter, scheduledPickUpBefore, scheduledPickUpAfter, currentShipmentStatus, vendorShipmentIdentifier, buyerReferenceNumber, buyerWarehouseCode, sellerWarehouseCode, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getShipmentDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentDetailsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipmentDetails operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentDetailsResponse> getShipmentDetailsWithHttpInfo(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode) throws ApiException, LWAException {
        return this.getShipmentDetailsWithHttpInfo(limit, sortOrder, nextToken, createdAfter, createdBefore, shipmentConfirmedBefore, shipmentConfirmedAfter, packageLabelCreatedBefore, packageLabelCreatedAfter, shippedBefore, shippedAfter, estimatedDeliveryBefore, estimatedDeliveryAfter, shipmentDeliveryBefore, shipmentDeliveryAfter, requestedPickUpBefore, requestedPickUpAfter, scheduledPickUpBefore, scheduledPickUpAfter, currentShipmentStatus, vendorShipmentIdentifier, buyerReferenceNumber, buyerWarehouseCode, sellerWarehouseCode, null);
    }

    public Call getShipmentDetailsAsync(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode, ApiCallback<GetShipmentDetailsResponse> callback) throws ApiException, LWAException {
        return this.getShipmentDetailsAsync(limit, sortOrder, nextToken, createdAfter, createdBefore, shipmentConfirmedBefore, shipmentConfirmedAfter, packageLabelCreatedBefore, packageLabelCreatedAfter, shippedBefore, shippedAfter, estimatedDeliveryBefore, estimatedDeliveryAfter, shipmentDeliveryBefore, shipmentDeliveryAfter, requestedPickUpBefore, requestedPickUpAfter, scheduledPickUpBefore, scheduledPickUpAfter, currentShipmentStatus, vendorShipmentIdentifier, buyerReferenceNumber, buyerWarehouseCode, sellerWarehouseCode, callback, null);
    }

    public Call getShipmentDetailsAsync(Long limit, String sortOrder, String nextToken, OffsetDateTime createdAfter, OffsetDateTime createdBefore, OffsetDateTime shipmentConfirmedBefore, OffsetDateTime shipmentConfirmedAfter, OffsetDateTime packageLabelCreatedBefore, OffsetDateTime packageLabelCreatedAfter, OffsetDateTime shippedBefore, OffsetDateTime shippedAfter, OffsetDateTime estimatedDeliveryBefore, OffsetDateTime estimatedDeliveryAfter, OffsetDateTime shipmentDeliveryBefore, OffsetDateTime shipmentDeliveryAfter, OffsetDateTime requestedPickUpBefore, OffsetDateTime requestedPickUpAfter, OffsetDateTime scheduledPickUpBefore, OffsetDateTime scheduledPickUpAfter, String currentShipmentStatus, String vendorShipmentIdentifier, String buyerReferenceNumber, String buyerWarehouseCode, String sellerWarehouseCode, ApiCallback<GetShipmentDetailsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentDetailsValidateBeforeCall(limit, sortOrder, nextToken, createdAfter, createdBefore, shipmentConfirmedBefore, shipmentConfirmedAfter, packageLabelCreatedBefore, packageLabelCreatedAfter, shippedBefore, shippedAfter, estimatedDeliveryBefore, estimatedDeliveryAfter, shipmentDeliveryBefore, shipmentDeliveryAfter, requestedPickUpBefore, requestedPickUpAfter, scheduledPickUpBefore, scheduledPickUpAfter, currentShipmentStatus, vendorShipmentIdentifier, buyerReferenceNumber, buyerWarehouseCode, sellerWarehouseCode, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getShipmentDetails");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentDetailsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentDetailsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipmentDetails operation exceeds rate limit");
    }

    private Call getShipmentLabelsCall(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        Object localVarPostBody = null;
        String localVarPath = "/vendor/shipping/v1/transportLabels".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/shipping/v1/transportLabels" : "/vendor/shipping/v1/transportLabels";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (nextToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("nextToken", nextToken));
        }
        if (labelCreatedAfter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelCreatedAfter", labelCreatedAfter));
        }
        if (labelCreatedBefore != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelCreatedBefore", labelCreatedBefore));
        }
        if (buyerReferenceNumber != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("buyerReferenceNumber", buyerReferenceNumber));
        }
        if (vendorShipmentIdentifier != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("vendorShipmentIdentifier", vendorShipmentIdentifier));
        }
        if (sellerWarehouseCode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sellerWarehouseCode", sellerWarehouseCode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call getShipmentLabelsValidateBeforeCall(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        return this.getShipmentLabelsCall(limit, sortOrder, nextToken, labelCreatedAfter, labelCreatedBefore, buyerReferenceNumber, vendorShipmentIdentifier, sellerWarehouseCode, progressRequestListener);
    }

    public GetShipmentLabels getShipmentLabels(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<GetShipmentLabels> resp = this.getShipmentLabelsWithHttpInfo(limit, sortOrder, nextToken, labelCreatedAfter, labelCreatedBefore, buyerReferenceNumber, vendorShipmentIdentifier, sellerWarehouseCode, restrictedDataToken);
        return resp.getData();
    }

    public GetShipmentLabels getShipmentLabels(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode) throws ApiException, LWAException {
        ApiResponse<GetShipmentLabels> resp = this.getShipmentLabelsWithHttpInfo(limit, sortOrder, nextToken, labelCreatedAfter, labelCreatedBefore, buyerReferenceNumber, vendorShipmentIdentifier, sellerWarehouseCode, null);
        return resp.getData();
    }

    public ApiResponse<GetShipmentLabels> getShipmentLabelsWithHttpInfo(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.getShipmentLabelsValidateBeforeCall(limit, sortOrder, nextToken, labelCreatedAfter, labelCreatedBefore, buyerReferenceNumber, vendorShipmentIdentifier, sellerWarehouseCode, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getShipmentLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentLabels>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("getShipmentLabels operation exceeds rate limit");
    }

    public ApiResponse<GetShipmentLabels> getShipmentLabelsWithHttpInfo(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode) throws ApiException, LWAException {
        return this.getShipmentLabelsWithHttpInfo(limit, sortOrder, nextToken, labelCreatedAfter, labelCreatedBefore, buyerReferenceNumber, vendorShipmentIdentifier, sellerWarehouseCode, null);
    }

    public Call getShipmentLabelsAsync(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode, ApiCallback<GetShipmentLabels> callback) throws ApiException, LWAException {
        return this.getShipmentLabelsAsync(limit, sortOrder, nextToken, labelCreatedAfter, labelCreatedBefore, buyerReferenceNumber, vendorShipmentIdentifier, sellerWarehouseCode, callback, null);
    }

    public Call getShipmentLabelsAsync(Long limit, String sortOrder, String nextToken, OffsetDateTime labelCreatedAfter, OffsetDateTime labelCreatedBefore, String buyerReferenceNumber, String vendorShipmentIdentifier, String sellerWarehouseCode, ApiCallback<GetShipmentLabels> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.getShipmentLabelsValidateBeforeCall(limit, sortOrder, nextToken, labelCreatedAfter, labelCreatedBefore, buyerReferenceNumber, vendorShipmentIdentifier, sellerWarehouseCode, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-getShipmentLabels");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.getShipmentLabelsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<GetShipmentLabels>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("getShipmentLabels operation exceeds rate limit");
    }

    private Call submitShipmentConfirmationsCall(SubmitShipmentConfirmationsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitShipmentConfirmationsRequest localVarPostBody = body;
        String localVarPath = "/vendor/shipping/v1/shipmentConfirmations".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/shipping/v1/shipmentConfirmations" : "/vendor/shipping/v1/shipmentConfirmations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitShipmentConfirmationsValidateBeforeCall(SubmitShipmentConfirmationsRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitShipmentConfirmations(Async)");
        }
        return this.submitShipmentConfirmationsCall(body, progressRequestListener);
    }

    public SubmitShipmentConfirmationsResponse submitShipmentConfirmations(SubmitShipmentConfirmationsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SubmitShipmentConfirmationsResponse> resp = this.submitShipmentConfirmationsWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public SubmitShipmentConfirmationsResponse submitShipmentConfirmations(SubmitShipmentConfirmationsRequest body) throws ApiException, LWAException {
        ApiResponse<SubmitShipmentConfirmationsResponse> resp = this.submitShipmentConfirmationsWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<SubmitShipmentConfirmationsResponse> submitShipmentConfirmationsWithHttpInfo(SubmitShipmentConfirmationsRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitShipmentConfirmationsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipmentConfirmations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentConfirmationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitShipmentConfirmationsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitShipmentConfirmations operation exceeds rate limit");
    }

    public ApiResponse<SubmitShipmentConfirmationsResponse> submitShipmentConfirmationsWithHttpInfo(SubmitShipmentConfirmationsRequest body) throws ApiException, LWAException {
        return this.submitShipmentConfirmationsWithHttpInfo(body, null);
    }

    public Call submitShipmentConfirmationsAsync(SubmitShipmentConfirmationsRequest body, ApiCallback<SubmitShipmentConfirmationsResponse> callback) throws ApiException, LWAException {
        return this.submitShipmentConfirmationsAsync(body, callback, null);
    }

    public Call submitShipmentConfirmationsAsync(SubmitShipmentConfirmationsRequest body, ApiCallback<SubmitShipmentConfirmationsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitShipmentConfirmationsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipmentConfirmations");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentConfirmationsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitShipmentConfirmationsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitShipmentConfirmations operation exceeds rate limit");
    }

    private Call submitShipmentsCall(SubmitShipments body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitShipments localVarPostBody = body;
        String localVarPath = "/vendor/shipping/v1/shipments".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/shipping/v1/shipments" : "/vendor/shipping/v1/shipments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitShipmentsValidateBeforeCall(SubmitShipments body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitShipments(Async)");
        }
        return this.submitShipmentsCall(body, progressRequestListener);
    }

    public SubmitShipmentConfirmationsResponse submitShipments(SubmitShipments body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SubmitShipmentConfirmationsResponse> resp = this.submitShipmentsWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public SubmitShipmentConfirmationsResponse submitShipments(SubmitShipments body) throws ApiException, LWAException {
        ApiResponse<SubmitShipmentConfirmationsResponse> resp = this.submitShipmentsWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<SubmitShipmentConfirmationsResponse> submitShipmentsWithHttpInfo(SubmitShipments body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitShipmentsValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitShipmentConfirmationsResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitShipments operation exceeds rate limit");
    }

    public ApiResponse<SubmitShipmentConfirmationsResponse> submitShipmentsWithHttpInfo(SubmitShipments body) throws ApiException, LWAException {
        return this.submitShipmentsWithHttpInfo(body, null);
    }

    public Call submitShipmentsAsync(SubmitShipments body, ApiCallback<SubmitShipmentConfirmationsResponse> callback) throws ApiException, LWAException {
        return this.submitShipmentsAsync(body, callback, null);
    }

    public Call submitShipmentsAsync(SubmitShipments body, ApiCallback<SubmitShipmentConfirmationsResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitShipmentsValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorShippingApi-submitShipments");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitShipmentsBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitShipmentConfirmationsResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitShipments operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VendorShippingApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VendorShippingApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

