/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.api.vendor.invoices.v1;

import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.SellingPartnerAPIAA.LWAException;
import com.amazon.SellingPartnerAPIAA.RestrictedDataTokenSigner;
import com.google.gson.reflect.TypeToken;
import io.github.bucket4j.Bucket;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Request;
import software.amazon.spapi.ApiCallback;
import software.amazon.spapi.ApiClient;
import software.amazon.spapi.ApiException;
import software.amazon.spapi.ApiResponse;
import software.amazon.spapi.Configuration;
import software.amazon.spapi.Pair;
import software.amazon.spapi.ProgressRequestBody;
import software.amazon.spapi.StringUtil;
import software.amazon.spapi.models.vendor.invoices.v1.SubmitInvoicesRequest;
import software.amazon.spapi.models.vendor.invoices.v1.SubmitInvoicesResponse;

public class VendorPaymentsApi {
    private ApiClient apiClient;
    private Boolean disableRateLimiting;
    private final Configuration config = Configuration.get();
    public final Bucket submitInvoicesBucket = Bucket.builder().addLimit(this.config.getLimit("VendorPaymentsApi-submitInvoices")).build();

    public VendorPaymentsApi(ApiClient apiClient, Boolean disableRateLimiting) {
        this.apiClient = apiClient;
        this.disableRateLimiting = disableRateLimiting;
    }

    private Call submitInvoicesCall(SubmitInvoicesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        SubmitInvoicesRequest localVarPostBody = body;
        String localVarPath = "/vendor/payments/v1/invoices".equals("/uploads/2020-11-01/uploadDestinations/{resource}") ? "/vendor/payments/v1/invoices" : "/vendor/payments/v1/invoices";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, progressRequestListener);
    }

    private Call submitInvoicesValidateBeforeCall(SubmitInvoicesRequest body, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException, LWAException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling submitInvoices(Async)");
        }
        return this.submitInvoicesCall(body, progressRequestListener);
    }

    public SubmitInvoicesResponse submitInvoices(SubmitInvoicesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        ApiResponse<SubmitInvoicesResponse> resp = this.submitInvoicesWithHttpInfo(body, restrictedDataToken);
        return resp.getData();
    }

    public SubmitInvoicesResponse submitInvoices(SubmitInvoicesRequest body) throws ApiException, LWAException {
        ApiResponse<SubmitInvoicesResponse> resp = this.submitInvoicesWithHttpInfo(body, null);
        return resp.getData();
    }

    public ApiResponse<SubmitInvoicesResponse> submitInvoicesWithHttpInfo(SubmitInvoicesRequest body, String restrictedDataToken) throws ApiException, LWAException {
        Call call = this.submitInvoicesValidateBeforeCall(body, null);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorPaymentsApi-submitInvoices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitInvoicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitInvoicesResponse>(){}.getType();
            return this.apiClient.execute(call, localVarReturnType);
        }
        throw new ApiException.RateLimitExceeded("submitInvoices operation exceeds rate limit");
    }

    public ApiResponse<SubmitInvoicesResponse> submitInvoicesWithHttpInfo(SubmitInvoicesRequest body) throws ApiException, LWAException {
        return this.submitInvoicesWithHttpInfo(body, null);
    }

    public Call submitInvoicesAsync(SubmitInvoicesRequest body, ApiCallback<SubmitInvoicesResponse> callback) throws ApiException, LWAException {
        return this.submitInvoicesAsync(body, callback, null);
    }

    public Call submitInvoicesAsync(SubmitInvoicesRequest body, ApiCallback<SubmitInvoicesResponse> callback, String restrictedDataToken) throws ApiException, LWAException {
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressRequestListener = callback::onUploadProgress;
        }
        Call call = this.submitInvoicesValidateBeforeCall(body, progressRequestListener);
        if (restrictedDataToken != null) {
            Request request = call.request();
            request = RestrictedDataTokenSigner.sign(request, restrictedDataToken, "VendorPaymentsApi-submitInvoices");
            call = this.apiClient.getHttpClient().newCall(request);
        }
        if (this.disableRateLimiting.booleanValue() || this.submitInvoicesBucket.tryConsume(1L)) {
            Type localVarReturnType = new TypeToken<SubmitInvoicesResponse>(){}.getType();
            this.apiClient.executeAsync(call, localVarReturnType, callback);
            return call;
        }
        throw new ApiException.RateLimitExceeded("submitInvoices operation exceeds rate limit");
    }

    public static class Builder {
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private Boolean disableRateLimiting = false;

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder disableRateLimiting() {
            this.disableRateLimiting = true;
            return this;
        }

        public VendorPaymentsApi build() {
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new VendorPaymentsApi(new ApiClient().setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint), this.disableRateLimiting);
        }
    }
}

